/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Function;
import com.google.gson.annotations.SerializedName;
import org.jclouds.javax.annotation.Nullable;

public class Address {
    @SerializedName(value="addr")
    private String address;
    private int version;

    private Address() {
    }

    public Address(String address, int version) {
        this.address = address;
        this.version = version;
    }

    public String getAddress() {
        return this.address;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address1 = (Address)o;
        if (this.version != address1.version) {
            return false;
        }
        return !(this.address != null ? !this.address.equals(address1.address) : address1.address != null);
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + this.version;
        return result;
    }

    public static Function<Address, String> newAddress2StringFunction() {
        return new Function<Address, String>(){

            public String apply(@Nullable Address input) {
                return input.getAddress();
            }
        };
    }

    public static Address valueOf(String address) {
        return new Address(address, address.startsWith("::") ? 6 : 4);
    }

    public static Function<String, Address> newString2AddressFunction() {
        return new Function<String, Address>(){

            public Address apply(@Nullable String input) {
                return Address.valueOf(input);
            }
        };
    }
}

