/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;

public class Resource {
    private List<Map<String, String>> links = Lists.newArrayList();
    private final ConcurrentSkipListMap<LinkType, URI> orderedSelfReferences = new ConcurrentSkipListMap();

    private void populateOrderedSelfReferences() {
        for (Map<String, String> linkProperties : this.links) {
            for (LinkType type : LinkType.values()) {
                if (!type.linkPredicate.apply(linkProperties)) continue;
                try {
                    this.orderedSelfReferences.put(type, new URI(linkProperties.get("href")));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.orderedSelfReferences.isEmpty()) {
            throw new IllegalStateException("URI is not available");
        }
    }

    public URI getURI() {
        if (this.orderedSelfReferences.isEmpty()) {
            this.populateOrderedSelfReferences();
        }
        return this.orderedSelfReferences.firstEntry().getValue();
    }

    public URI getSelfURI() {
        if (this.orderedSelfReferences.isEmpty()) {
            this.populateOrderedSelfReferences();
        }
        return this.orderedSelfReferences.get((Object)LinkType.SELF);
    }

    private static enum LinkType {
        BOOKMARK_JSON(new Predicate<Map<String, String>>(){

            public boolean apply(@Nullable Map<String, String> linkMap) {
                return ((String)Functions.forMap(linkMap, (Object)"").apply((Object)"rel")).equals("bookmark") && ((String)Functions.forMap(linkMap, (Object)"").apply((Object)"type")).contains("json");
            }
        }),
        BOOKMARK_ANY(new Predicate<Map<String, String>>(){

            public boolean apply(@Nullable Map<String, String> linkMap) {
                return ((String)Functions.forMap(linkMap, (Object)"").apply((Object)"rel")).equals("bookmark");
            }
        }),
        SELF(new Predicate<Map<String, String>>(){

            public boolean apply(@Nullable Map<String, String> linkMap) {
                return ((String)Functions.forMap(linkMap, (Object)"").apply((Object)"rel")).equals("self");
            }
        });

        Predicate<Map<String, String>> linkPredicate;

        private LinkType(Predicate<Map<String, String>> linkPredicate) {
            this.linkPredicate = linkPredicate;
        }
    }
}

