/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.NovaClient;
import org.jclouds.openstack.nova.domain.Server;
import org.jclouds.openstack.nova.domain.ServerStatus;

@Singleton
public class ServerActive
implements Predicate<Server> {
    private final NovaClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public ServerActive(NovaClient client) {
        this.client = client;
    }

    public boolean apply(Server server) {
        this.logger.trace("looking for state on server %s", new Object[]{Preconditions.checkNotNull((Object)server, (Object)"server")});
        server = this.refresh(server);
        if (server == null) {
            return false;
        }
        this.logger.trace("%s: looking for server state %s: currently: %s", new Object[]{server.getId(), ServerStatus.ACTIVE, server.getStatus()});
        return server.getStatus() == ServerStatus.ACTIVE;
    }

    private Server refresh(Server server) {
        return this.client.getServer(server.getId());
    }
}

