/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.dozer;

import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.dozer.DozerBeanMapper;

public class DozerTypeConverter
implements TypeConverter {
    private DozerBeanMapper mapper;

    public DozerTypeConverter(DozerBeanMapper mapper) {
        this.mapper = mapper;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return (T)this.mapper.map(value, type);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return this.convertTo(type, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.convertTo(type, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        return this.convertTo(type, value);
    }

    public <T> T tryConvertTo(Class<T> type, Object value) {
        try {
            return this.convertTo(type, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            return this.convertTo(type, value);
        }
        catch (Exception e) {
            return null;
        }
    }
}

