/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.config;

import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.s3.AWSS3AsyncClient;
import org.jclouds.aws.s3.AWSS3Client;
import org.jclouds.aws.s3.binders.AssignCorrectHostnameAndBindAsHostPrefixIfConfigured;
import org.jclouds.http.RequiresHttp;
import org.jclouds.location.Region;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.RestContext;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.binders.BindAsHostPrefixIfConfigured;
import org.jclouds.s3.config.S3RestClientModule;

@RequiresHttp
@ConfiguresRestClient
public class AWSS3RestClientModule
extends S3RestClientModule<AWSS3Client, AWSS3AsyncClient> {
    @Provides
    @Singleton
    @Bucket
    protected URI provideBucketURI(@Named(value="jclouds.region.us-standard.endpoint") String endpoint) {
        return URI.create(endpoint);
    }

    protected String defaultRegionForBucket(@Region String defaultRegion) {
        return "us-standard";
    }

    protected void configure() {
        this.bind(BindAsHostPrefixIfConfigured.class).to(AssignCorrectHostnameAndBindAsHostPrefixIfConfigured.class);
        super.configure();
    }

    public AWSS3RestClientModule() {
        super(AWSS3Client.class, AWSS3AsyncClient.class);
    }

    @Singleton
    @Provides
    S3Client provide(AWSS3Client in) {
        return in;
    }

    @Singleton
    @Provides
    S3AsyncClient provide(AWSS3AsyncClient in) {
        return in;
    }

    @Singleton
    @Provides
    RestContext<S3Client, S3AsyncClient> provideBaseContext(RestContext<AWSS3Client, AWSS3AsyncClient> in) {
        return in;
    }
}

