/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMapConfigCallable
implements Callable<MapConfig>,
HazelcastInstanceAware,
DataSerializable {
    private static final long serialVersionUID = -3496139512682608428L;
    protected transient HazelcastInstance hazelcastInstance;
    protected String mapName;

    public GetMapConfigCallable() {
    }

    public GetMapConfigCallable(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    public MapConfig call() throws Exception {
        final AtomicReference ref = new AtomicReference();
        this.getClusterService().enqueueAndWait(new Processable(){

            public void process() {
                CMap cmap = GetMapConfigCallable.this.getCMap();
                MapConfig cfg = cmap.getRuntimeConfig();
                ref.set(cfg);
            }
        }, 5);
        return (MapConfig)ref.get();
    }

    ConcurrentMapManager getConcurrentMapManager() {
        FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
        return factory.node.concurrentMapManager;
    }

    ClusterService getClusterService() {
        FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
        return factory.node.clusterService;
    }

    CMap getCMap() {
        return this.getConcurrentMapManager().getOrCreateMap("c:" + this.mapName);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.mapName);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.mapName = in.readUTF();
    }
}

