/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sip;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.SipFactory;
import javax.sip.SipStack;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.ExtensionHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import org.apache.camel.component.sip.SipComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipConfiguration {
    private static final transient Logger LOG = LoggerFactory.getLogger(SipConfiguration.class);
    private static final String IMPLEMENTATION = "gov.nist";
    private java.net.URI uri;
    private Map<String, Object> parameters;
    private SipComponent component;
    private AddressFactory addressFactory;
    private MessageFactory messageFactory;
    private HeaderFactory headerFactory;
    private SipStack sipStack;
    private ListeningPoint listeningPoint;
    private String protocol;
    private SipURI sipUri;
    private String stackName;
    private String transport;
    private int maxForwards;
    private boolean consumer;
    private String eventHeaderName;
    private String eventId;
    private int msgExpiration;
    private String useRouterForAllUris;
    private long receiveTimeoutMillis;
    private String maxMessageSize;
    private String cacheConnections;
    private String contentType;
    private String contentSubType;
    private String automaticDialogSupport;
    private String nistServerLog;
    private String nistDebugLog;
    private String nistTraceLevel;
    private SipFactory sipFactory = SipFactory.getInstance();
    private String fromUser;
    private String fromHost;
    private int fromPort;
    private String toUser;
    private String toHost;
    private int toPort;
    private boolean presenceAgent;
    private FromHeader fromHeader;
    private ToHeader toHeader;
    private ArrayList<ViaHeader> viaHeaders;
    private ContentTypeHeader contentTypeHeader;
    private CallIdHeader callIdHeader;
    private MaxForwardsHeader maxForwardsHeader;
    private ContactHeader contactHeader;
    private EventHeader eventHeader;
    private ExtensionHeader extensionHeader;
    private ExpiresHeader expiresHeader;
    private ClientTransaction clientTransactionId;
    private Dialog dialog;

    public SipConfiguration() {
        this.sipFactory.setPathName(IMPLEMENTATION);
        this.setStackName("NAME_NOT_SET");
        this.setTransport("tcp");
        this.setMaxMessageSize("1048576");
        this.setCacheConnections("false");
        this.setAutomaticDialogSupport("off");
        this.setContentType("text");
        this.setContentSubType("plain");
        this.setReceiveTimeoutMillis(10000L);
        this.setConsumer(false);
        this.setUseRouterForAllUris("false");
        this.setMsgExpiration(3600);
        this.setPresenceAgent(false);
    }

    public void initialize(java.net.URI uri, Map<String, Object> parameters, SipComponent component) {
        this.setParameters(parameters);
        this.setComponent(component);
        this.setUri(uri);
    }

    public void parseURI() throws Exception {
        this.protocol = this.uri.getScheme();
        if (!this.protocol.equalsIgnoreCase("sip") && !this.protocol.equalsIgnoreCase("sips")) {
            throw new IllegalArgumentException("Unrecognized SIP protocol: " + this.protocol + " for uri: " + this.uri);
        }
        Map settings = URISupport.parseParameters((java.net.URI)this.uri);
        if (settings.containsKey("stackName")) {
            this.setStackName((String)settings.get("stackName"));
        }
        if (settings.containsKey("transport")) {
            this.setTransport((String)settings.get("transport"));
        }
        if (settings.containsKey("maxMessageSize")) {
            this.setMaxMessageSize((String)settings.get("maxMessageSize"));
        }
        if (settings.containsKey("cacheConnections")) {
            this.setCacheConnections((String)settings.get("cacheConnections"));
        }
        if (settings.containsKey("contentType")) {
            this.setContentType((String)settings.get("contentType"));
        }
        if (settings.containsKey("contentSubType")) {
            this.setContentSubType((String)settings.get("contentSubType"));
        }
        if (settings.containsKey("maxForwards")) {
            this.setMaxForwards(Integer.valueOf((String)settings.get("maxForwards")));
        }
        if (settings.containsKey("receiveTimeoutMillis")) {
            this.setReceiveTimeoutMillis(Long.valueOf((String)settings.get("receiveTimeoutMillis")));
        }
        if (settings.containsKey("eventHeaderName")) {
            this.setEventHeaderName((String)settings.get("eventHeaderName"));
        }
        if (settings.containsKey("eventId")) {
            this.setEventId((String)settings.get("eventId"));
        }
        if (settings.containsKey("useRouterForAllUris")) {
            this.setUseRouterForAllUris((String)settings.get("useRouterForAllUris"));
        }
        if (settings.containsKey("msgExpiration")) {
            this.setMsgExpiration(Integer.valueOf((String)settings.get("msgExpiration")));
        }
        if (settings.containsKey("presenceAgent")) {
            this.setPresenceAgent(Boolean.valueOf((String)settings.get("presenceAgent")));
        }
        if (!this.consumer) {
            if (settings.containsKey("fromUser")) {
                this.setFromUser((String)settings.get("fromUser"));
            }
            if (settings.containsKey("fromHost")) {
                this.setFromHost((String)settings.get("fromHost"));
            }
            if (settings.containsKey("fromPort")) {
                this.setFromPort(Integer.valueOf((String)settings.get("fromPort")));
            }
            this.setToUser(this.uri.getUserInfo());
            this.setToHost(this.uri.getHost());
            this.setToPort(this.uri.getPort());
        } else {
            this.setFromUser(this.uri.getUserInfo());
            this.setFromHost(this.uri.getHost());
            this.setFromPort(this.uri.getPort());
            if (!this.presenceAgent) {
                if (settings.containsKey("toUser")) {
                    this.setToUser((String)settings.get("toUser"));
                }
                if (settings.containsKey("toHost")) {
                    this.setToHost((String)settings.get("toHost"));
                }
                if (settings.containsKey("toPort")) {
                    this.setToPort(Integer.valueOf((String)settings.get("toPort")));
                }
            }
        }
        this.nistDebugLog = (String)this.component.getAndRemoveParameter(this.parameters, "implementationDebugLogFile", String.class, null);
        this.nistServerLog = (String)this.component.getAndRemoveParameter(this.parameters, "implementationServerLogFile", String.class, null);
        this.nistTraceLevel = (String)this.component.getAndRemoveParameter(this.parameters, "implementationTraceLevel", String.class, "0");
        LOG.trace("Consumer:" + this.consumer + " StackName:" + this.stackName);
        LOG.trace("From User: " + this.getFromUser() + " From host: " + this.getFromHost() + " From Port: " + this.getFromPort());
        this.createFactoriesAndHeaders(this.parameters, this.component);
        this.sipUri = (SipURI)this.component.resolveAndRemoveReferenceParameter(this.parameters, "sipUri", SipURI.class, null);
        if (this.sipUri == null) {
            this.sipUri = this.addressFactory.createSipURI(this.getToUser(), this.getToHost() + ":" + this.getToPort());
        }
        ObjectHelper.notNull((Object)this.fromUser, (String)"From User");
        ObjectHelper.notNull((Object)this.fromHost, (String)"From Host");
        ObjectHelper.notNull((Object)this.fromPort, (String)"From Port");
        ObjectHelper.notNull((Object)this.eventHeader, (String)"Event Header");
        ObjectHelper.notNull((Object)this.eventHeaderName, (String)"Event Header Name");
        ObjectHelper.notNull((Object)this.eventId, (String)"Event Id");
    }

    private void createFactoriesAndHeaders(Map<String, Object> parameters, SipComponent component) throws Exception {
        this.headerFactory = this.sipFactory.createHeaderFactory();
        this.addressFactory = this.sipFactory.createAddressFactory();
        this.setMessageFactory(this.sipFactory.createMessageFactory());
        this.fromHeader = (FromHeader)component.resolveAndRemoveReferenceParameter(parameters, "fromHeader", FromHeader.class, null);
        if (this.fromHeader == null) {
            this.createFromHeader();
        }
        if (!this.presenceAgent) {
            this.toHeader = (ToHeader)component.resolveAndRemoveReferenceParameter(parameters, "toHeader", ToHeader.class, null);
            if (this.toHeader == null) {
                this.createToHeader();
            }
        }
        this.viaHeaders = (ArrayList)component.resolveAndRemoveReferenceParameter(parameters, "viaHeaders", ArrayList.class, null);
        if (this.viaHeaders == null) {
            this.createViaHeaders();
        }
        this.contentTypeHeader = (ContentTypeHeader)component.resolveAndRemoveReferenceParameter(parameters, "contentTypeHeader", ContentTypeHeader.class, null);
        if (this.contentTypeHeader == null) {
            this.createContentTypeHeader();
        }
        this.callIdHeader = (CallIdHeader)component.resolveAndRemoveReferenceParameter(parameters, "callIdHeader", CallIdHeader.class, null);
        this.maxForwardsHeader = (MaxForwardsHeader)component.resolveAndRemoveReferenceParameter(parameters, "maxForwardsHeader", MaxForwardsHeader.class, null);
        if (this.maxForwardsHeader == null) {
            this.createMaxForwardsHeader();
        }
        this.eventHeader = (EventHeader)component.resolveAndRemoveReferenceParameter(parameters, "eventHeader", EventHeader.class, null);
        if (this.eventHeader == null) {
            this.createEventHeader();
        }
        this.contactHeader = (ContactHeader)component.resolveAndRemoveReferenceParameter(parameters, "contactHeader", ContactHeader.class, null);
        if (this.contactHeader == null) {
            this.createContactHeader();
        }
        this.expiresHeader = (ExpiresHeader)component.resolveAndRemoveReferenceParameter(parameters, "expiresHeader", ExpiresHeader.class, null);
        if (this.expiresHeader == null) {
            this.createExpiresHeader();
        }
        this.extensionHeader = (ExtensionHeader)component.resolveAndRemoveReferenceParameter(parameters, "extensionHeader", ExtensionHeader.class, null);
    }

    public Request createSipRequest(long sequenceNumber, String requestMethod, Object body) throws ParseException, InvalidArgumentException {
        CSeqHeader cSeqHeader = this.getHeaderFactory().createCSeqHeader(sequenceNumber, requestMethod);
        Request request = this.getMessageFactory().createRequest((URI)this.getSipUri(), requestMethod, this.getCallIdHeader(), cSeqHeader, this.getFromHeader(), this.getToHeader(), this.getViaHeaders(), this.getMaxForwardsHeader());
        if (this.getEventHeader() != null) {
            request.addHeader((Header)this.getEventHeader());
        }
        if (this.getExpiresHeader() != null) {
            request.addHeader((Header)this.getExpiresHeader());
        }
        if (this.getContactHeader() != null) {
            request.addHeader((Header)this.getContactHeader());
        }
        if (this.getExtensionHeader() != null) {
            request.addHeader((Header)this.getExtensionHeader());
        }
        request.setContent(body, this.getContentTypeHeader());
        return request;
    }

    private void createFromHeader() throws ParseException {
        SipURI fromAddress = this.getAddressFactory().createSipURI(this.getFromUser(), this.getFromHost());
        fromAddress.setPort(Integer.valueOf(this.getFromPort()).intValue());
        Address fromNameAddress = this.addressFactory.createAddress((URI)fromAddress);
        fromNameAddress.setDisplayName(this.getFromUser());
        this.setFromHeader(this.headerFactory.createFromHeader(fromNameAddress, this.getFromUser() + "_Header"));
    }

    private void createToHeader() throws ParseException {
        SipURI toAddress = this.getAddressFactory().createSipURI(this.getToUser(), this.getToHost());
        toAddress.setPort(this.getToPort());
        Address toNameAddress = this.addressFactory.createAddress((URI)toAddress);
        toNameAddress.setDisplayName(this.getToUser());
        this.setToHeader(this.headerFactory.createToHeader(toNameAddress, this.getToUser() + "_Header"));
    }

    private void createViaHeaders() throws ParseException, InvalidArgumentException {
        this.viaHeaders = new ArrayList();
        ViaHeader viaHeader = this.headerFactory.createViaHeader(this.getFromHost(), this.getFromPort(), this.getTransport(), null);
        this.viaHeaders.add(viaHeader);
    }

    private void createContentTypeHeader() throws ParseException {
        this.setContentTypeHeader(this.headerFactory.createContentTypeHeader(this.getContentType(), this.getContentSubType()));
    }

    private void createMaxForwardsHeader() throws ParseException, InvalidArgumentException {
        this.setMaxForwardsHeader(this.headerFactory.createMaxForwardsHeader(this.getMaxForwards()));
    }

    private void createEventHeader() throws ParseException {
        this.eventHeader = this.getHeaderFactory().createEventHeader(this.getEventHeaderName());
        this.eventHeader.setEventId(this.getEventId());
    }

    private void createContactHeader() throws ParseException {
        SipURI contactURI = this.addressFactory.createSipURI(this.getFromUser(), this.getFromHost());
        contactURI.setTransportParam(this.getTransport());
        contactURI.setPort(Integer.valueOf(this.getFromPort()).intValue());
        Address contactAddress = this.addressFactory.createAddress((URI)contactURI);
        contactAddress.setDisplayName(this.getFromUser());
        this.contactHeader = this.headerFactory.createContactHeader(contactAddress);
    }

    private void createExpiresHeader() throws ParseException, InvalidArgumentException {
        this.expiresHeader = this.getHeaderFactory().createExpiresHeader(this.getMsgExpiration());
    }

    Properties createInitialProperties() {
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", this.getStackName());
        properties.setProperty("gov.nist.javax.sip.MAX_MESSAGE_SIZE", this.getMaxMessageSize());
        properties.setProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS", this.getCacheConnections());
        properties.setProperty("javax.sip.USE_ROUTER_FOR_ALL_URIS", this.getUseRouterForAllUris());
        if (this.nistDebugLog != null && this.nistServerLog != null) {
            properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", this.nistDebugLog);
            properties.setProperty("gov.nist.javax.sip.SERVER_LOG", this.nistServerLog);
            properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", this.nistTraceLevel);
        }
        return properties;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public void setAddressFactory(AddressFactory addressFactory) {
        this.addressFactory = addressFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public void setHeaderFactory(HeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public void setSipStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public SipURI getSipUri() {
        return this.sipUri;
    }

    public void setSipUri(SipURI sipUri) {
        this.sipUri = sipUri;
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(String maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public String getAutomaticDialogSupport() {
        return this.automaticDialogSupport;
    }

    public void setAutomaticDialogSupport(String automaticDialogSupport) {
        this.automaticDialogSupport = automaticDialogSupport;
    }

    public String getCacheConnections() {
        return this.cacheConnections;
    }

    public void setCacheConnections(String cacheConnections) {
        this.cacheConnections = cacheConnections;
    }

    public ListeningPoint getListeningPoint() {
        return this.listeningPoint;
    }

    public void setListeningPoint(ListeningPoint listeningPoint) {
        this.listeningPoint = listeningPoint;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentSubType(String contentSubType) {
        this.contentSubType = contentSubType;
    }

    public String getContentSubType() {
        return this.contentSubType;
    }

    public void setMaxForwards(int maxForwards) {
        this.maxForwards = maxForwards;
    }

    public int getMaxForwards() {
        return this.maxForwards;
    }

    public void setReceiveTimeoutMillis(long receiveTimeoutMillis) {
        this.receiveTimeoutMillis = receiveTimeoutMillis;
    }

    public long getReceiveTimeoutMillis() {
        return this.receiveTimeoutMillis;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setComponent(SipComponent component) {
        this.component = component;
    }

    public SipComponent getComponent() {
        return this.component;
    }

    public String getNistServerLog() {
        return this.nistServerLog;
    }

    public void setNistServerLog(String nistServerLog) {
        this.nistServerLog = nistServerLog;
    }

    public String getNistDebugLog() {
        return this.nistDebugLog;
    }

    public void setNistDebugLog(String nistDebugLog) {
        this.nistDebugLog = nistDebugLog;
    }

    public String getNistTraceLevel() {
        return this.nistTraceLevel;
    }

    public void setNistTraceLevel(String nistTraceLevel) {
        this.nistTraceLevel = nistTraceLevel;
    }

    public SipFactory getSipFactory() {
        return this.sipFactory;
    }

    public void setSipFactory(SipFactory sipFactory) {
        this.sipFactory = sipFactory;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public String getFromHost() {
        return this.fromHost;
    }

    public void setFromHost(String fromHost) {
        this.fromHost = fromHost;
    }

    public int getFromPort() {
        return this.fromPort;
    }

    public void setFromPort(int fromPort) {
        this.fromPort = fromPort;
    }

    public String getToUser() {
        return this.toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public String getToHost() {
        return this.toHost;
    }

    public void setToHost(String toHost) {
        this.toHost = toHost;
    }

    public int getToPort() {
        return this.toPort;
    }

    public void setToPort(int toPort) {
        this.toPort = toPort;
    }

    public FromHeader getFromHeader() {
        return this.fromHeader;
    }

    public void setFromHeader(FromHeader fromHeader) {
        this.fromHeader = fromHeader;
    }

    public ToHeader getToHeader() {
        return this.toHeader;
    }

    public void setToHeader(ToHeader toHeader) {
        this.toHeader = toHeader;
    }

    public ArrayList<ViaHeader> getViaHeaders() {
        return this.viaHeaders;
    }

    public void setViaHeaders(ArrayList<ViaHeader> viaHeaders) {
        this.viaHeaders = viaHeaders;
    }

    public ContentTypeHeader getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(ContentTypeHeader contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public CallIdHeader getCallIdHeader() {
        return this.callIdHeader;
    }

    public void setCallIdHeader(CallIdHeader callIdHeader) {
        this.callIdHeader = callIdHeader;
    }

    public MaxForwardsHeader getMaxForwardsHeader() {
        return this.maxForwardsHeader;
    }

    public void setMaxForwardsHeader(MaxForwardsHeader maxForwardsHeader) {
        this.maxForwardsHeader = maxForwardsHeader;
    }

    public ContactHeader getContactHeader() {
        return this.contactHeader;
    }

    public void setContactHeader(ContactHeader contactHeader) {
        this.contactHeader = contactHeader;
    }

    public ExtensionHeader getExtensionHeader() {
        return this.extensionHeader;
    }

    public void setExtensionHeader(ExtensionHeader extensionHeader) {
        this.extensionHeader = extensionHeader;
    }

    public void setUri(java.net.URI uri) {
        this.uri = uri;
    }

    public java.net.URI getUri() {
        return this.uri;
    }

    public void setConsumer(boolean consumer) {
        this.consumer = consumer;
    }

    public boolean isConsumer() {
        return this.consumer;
    }

    public void setClientTransactionId(ClientTransaction clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
    }

    public ClientTransaction getClientTransactionId() {
        return this.clientTransactionId;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setEventHeader(EventHeader eventHeader) {
        this.eventHeader = eventHeader;
    }

    public EventHeader getEventHeader() {
        return this.eventHeader;
    }

    public void setEventHeaderName(String eventHeaderName) {
        this.eventHeaderName = eventHeaderName;
    }

    public String getEventHeaderName() {
        return this.eventHeaderName;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setUseRouterForAllUris(String useRouterForAllUris) {
        this.useRouterForAllUris = useRouterForAllUris;
    }

    public String getUseRouterForAllUris() {
        return this.useRouterForAllUris;
    }

    public int getMsgExpiration() {
        return this.msgExpiration;
    }

    public void setMsgExpiration(int msgExpiration) {
        this.msgExpiration = msgExpiration;
    }

    public ExpiresHeader getExpiresHeader() {
        return this.expiresHeader;
    }

    public void setExpiresHeader(ExpiresHeader expiresHeader) {
        this.expiresHeader = expiresHeader;
    }

    public boolean isPresenceAgent() {
        return this.presenceAgent;
    }

    public void setPresenceAgent(boolean presenceAgent) {
        this.presenceAgent = presenceAgent;
    }
}

