/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.loadbalancer;

import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.loadbalancer.LoadBalancerServiceContext;
import org.jclouds.loadbalancer.LoadBalancerServiceContextBuilder;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.util.Throwables2;

public class LoadBalancerServiceContextFactory {
    private final RestContextFactory contextFactory;

    public LoadBalancerServiceContextFactory() {
        this(new RestContextFactory());
    }

    public LoadBalancerServiceContextFactory(Properties properties) {
        this(new RestContextFactory(properties));
    }

    public LoadBalancerServiceContextFactory(RestContextFactory restContextFactory) {
        this.contextFactory = restContextFactory;
    }

    public static <S, A> LoadBalancerServiceContext buildContextUnwrappingExceptions(LoadBalancerServiceContextBuilder<S, A> builder) {
        try {
            return builder.buildLoadBalancerServiceContext();
        }
        catch (Exception e) {
            return (LoadBalancerServiceContext)Throwables2.propagateAuthorizationOrOriginalException((Exception)e);
        }
    }

    public LoadBalancerServiceContext createContext(String provider, String identity, String credential) {
        LoadBalancerServiceContextBuilder builder = (LoadBalancerServiceContextBuilder)((Object)LoadBalancerServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, identity, credential)));
        return LoadBalancerServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public LoadBalancerServiceContext createContext(String provider, Properties overrides) {
        LoadBalancerServiceContextBuilder builder = (LoadBalancerServiceContextBuilder)((Object)LoadBalancerServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, overrides)));
        return LoadBalancerServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public LoadBalancerServiceContext createContext(String provider, Iterable<? extends Module> modules, Properties overrides) {
        LoadBalancerServiceContextBuilder builder = (LoadBalancerServiceContextBuilder)((Object)LoadBalancerServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, modules, overrides)));
        return LoadBalancerServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public LoadBalancerServiceContext createContext(String provider, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> modules) {
        LoadBalancerServiceContextBuilder builder = (LoadBalancerServiceContextBuilder)((Object)LoadBalancerServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, identity, credential, modules)));
        return LoadBalancerServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public LoadBalancerServiceContext createContext(String provider, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> modules, Properties overrides) {
        LoadBalancerServiceContextBuilder builder = (LoadBalancerServiceContextBuilder)((Object)LoadBalancerServiceContextBuilder.class.cast(this.contextFactory.createContextBuilder(provider, identity, credential, modules, overrides)));
        return LoadBalancerServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> LoadBalancerServiceContext createContext(RestContextSpec<S, A> contextSpec) {
        LoadBalancerServiceContextBuilder builder = (LoadBalancerServiceContextBuilder)((Object)LoadBalancerServiceContextBuilder.class.cast(RestContextFactory.createContextBuilder(contextSpec)));
        return LoadBalancerServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> LoadBalancerServiceContext createContext(RestContextSpec<S, A> contextSpec, Properties overrides) {
        LoadBalancerServiceContextBuilder builder = (LoadBalancerServiceContextBuilder)((Object)LoadBalancerServiceContextBuilder.class.cast(RestContextFactory.createContextBuilder(contextSpec, (Properties)overrides)));
        return LoadBalancerServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> LoadBalancerServiceContext createContext(RestContextSpec<S, A> contextSpec, Iterable<Module> modules, Properties overrides) {
        LoadBalancerServiceContextBuilder builder = (LoadBalancerServiceContextBuilder)((Object)LoadBalancerServiceContextBuilder.class.cast(RestContextFactory.createContextBuilder(contextSpec, modules, (Properties)overrides)));
        return LoadBalancerServiceContextFactory.buildContextUnwrappingExceptions(builder);
    }
}

