/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.loadbalancer.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Location;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.loadbalancer.LoadBalancerService;
import org.jclouds.loadbalancer.LoadBalancerServiceContext;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.strategy.DestroyLoadBalancerStrategy;
import org.jclouds.loadbalancer.strategy.GetLoadBalancerMetadataStrategy;
import org.jclouds.loadbalancer.strategy.ListLoadBalancersStrategy;
import org.jclouds.loadbalancer.strategy.LoadBalanceNodesStrategy;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;

@Singleton
public class BaseLoadBalancerService
implements LoadBalancerService {
    @Resource
    @Named(value="jclouds.loadbalancer")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Location> defaultLocationSupplier;
    protected final LoadBalancerServiceContext context;
    protected final LoadBalanceNodesStrategy loadBalancerStrategy;
    protected final GetLoadBalancerMetadataStrategy getLoadBalancerMetadataStrategy;
    protected final DestroyLoadBalancerStrategy destroyLoadBalancerStrategy;
    protected final ListLoadBalancersStrategy listLoadBalancersStrategy;
    protected final Supplier<Set<? extends Location>> locations;

    @Inject
    protected BaseLoadBalancerService(Supplier<Location> defaultLocationSupplier, LoadBalancerServiceContext context, LoadBalanceNodesStrategy loadBalancerStrategy, GetLoadBalancerMetadataStrategy getLoadBalancerMetadataStrategy, DestroyLoadBalancerStrategy destroyLoadBalancerStrategy, ListLoadBalancersStrategy listLoadBalancersStrategy, @Memoized Supplier<Set<? extends Location>> locations) {
        this.defaultLocationSupplier = (Supplier)Preconditions.checkNotNull(defaultLocationSupplier, (Object)"defaultLocationSupplier");
        this.context = (LoadBalancerServiceContext)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.loadBalancerStrategy = (LoadBalanceNodesStrategy)Preconditions.checkNotNull((Object)loadBalancerStrategy, (Object)"loadBalancerStrategy");
        this.getLoadBalancerMetadataStrategy = (GetLoadBalancerMetadataStrategy)Preconditions.checkNotNull((Object)getLoadBalancerMetadataStrategy, (Object)"getLoadBalancerMetadataStrategy");
        this.destroyLoadBalancerStrategy = (DestroyLoadBalancerStrategy)Preconditions.checkNotNull((Object)destroyLoadBalancerStrategy, (Object)"destroyLoadBalancerStrategy");
        this.listLoadBalancersStrategy = (ListLoadBalancersStrategy)Preconditions.checkNotNull((Object)listLoadBalancersStrategy, (Object)"listLoadBalancersStrategy");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return (Set)this.locations.get();
    }

    @Override
    public LoadBalancerServiceContext getContext() {
        return this.context;
    }

    @Override
    public LoadBalancerMetadata createLoadBalancerInLocation(@Nullable Location location, String loadBalancerName, String protocol, int loadBalancerPort, int instancePort, Iterable<? extends NodeMetadata> nodes) {
        if (location == null) {
            location = (Location)this.defaultLocationSupplier.get();
        }
        Preconditions.checkNotNull((Object)loadBalancerName, (Object)"loadBalancerName");
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol");
        Preconditions.checkArgument((protocol.toUpperCase().equals("HTTP") || protocol.toUpperCase().equals("TCP") ? 1 : 0) != 0, (Object)"Acceptable values for protocol are HTTP or TCP");
        this.logger.debug(">> creating load balancer (%s)", new Object[]{loadBalancerName});
        LoadBalancerMetadata lb = this.loadBalancerStrategy.createLoadBalancerInLocation(location, loadBalancerName, protocol, loadBalancerPort, instancePort, nodes);
        this.logger.debug("<< created load balancer (%s)", new Object[]{loadBalancerName, lb});
        return lb;
    }

    @Override
    public LoadBalancerMetadata getLoadBalancerMetadata(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        return this.getLoadBalancerMetadataStrategy.getLoadBalancer(id);
    }

    @Override
    public void destroyLoadBalancer(final String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.logger.debug(">> destroying load balancer(%s)", new Object[]{id});
        final AtomicReference loadBalancer = new AtomicReference();
        RetryablePredicate tester = new RetryablePredicate((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    LoadBalancerMetadata md = BaseLoadBalancerService.this.destroyLoadBalancerStrategy.destroyLoadBalancer(id);
                    if (md != null) {
                        loadBalancer.set(md);
                    }
                    return true;
                }
                catch (IllegalStateException e) {
                    BaseLoadBalancerService.this.logger.warn("<< illegal state destroying load balancer(%s)", new Object[]{id});
                    return false;
                }
            }
        }, 3000L, 1000L, TimeUnit.MILLISECONDS);
        boolean successful = tester.apply((Object)id) && loadBalancer.get() == null;
        this.logger.debug("<< destroyed load balancer(%s) success(%s)", new Object[]{id, successful});
    }

    @Override
    public Set<? extends LoadBalancerMetadata> listLoadBalancers() {
        this.logger.debug(">> listing load balancers", new Object[0]);
        LinkedHashSet set = Sets.newLinkedHashSet(this.listLoadBalancersStrategy.listLoadBalancers());
        this.logger.debug("<< list(%d)", new Object[]{set.size()});
        return set;
    }
}

