/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.management.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.ApplicationMetadataFactory;
import org.apache.aries.application.DeploymentMetadata;
import org.apache.aries.application.DeploymentMetadataFactory;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.filesystem.IFile;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.AriesApplicationContext;
import org.apache.aries.application.management.AriesApplicationListener;
import org.apache.aries.application.management.AriesApplicationManager;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ManagementException;
import org.apache.aries.application.management.ResolveConstraint;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.management.UpdateException;
import org.apache.aries.application.management.impl.AriesApplicationImpl;
import org.apache.aries.application.management.internal.MessageUtil;
import org.apache.aries.application.management.repository.ApplicationRepository;
import org.apache.aries.application.management.spi.convert.BundleConversion;
import org.apache.aries.application.management.spi.convert.BundleConverter;
import org.apache.aries.application.management.spi.convert.ConversionException;
import org.apache.aries.application.management.spi.repository.BundleRepository;
import org.apache.aries.application.management.spi.resolve.DeploymentManifestManager;
import org.apache.aries.application.management.spi.runtime.AriesApplicationContextManager;
import org.apache.aries.application.management.spi.runtime.LocalPlatform;
import org.apache.aries.application.utils.filesystem.FileSystem;
import org.apache.aries.application.utils.filesystem.IOUtils;
import org.apache.aries.application.utils.management.SimpleBundleInfo;
import org.apache.aries.application.utils.manifest.BundleManifest;
import org.apache.aries.application.utils.manifest.ManifestDefaultsInjector;
import org.apache.aries.application.utils.manifest.ManifestProcessor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AriesApplicationManagerImpl
implements AriesApplicationManager {
    private ApplicationMetadataFactory _applicationMetadataFactory;
    private DeploymentMetadataFactory _deploymentMetadataFactory;
    private List<BundleConverter> _bundleConverters;
    private LocalPlatform _localPlatform;
    private AriesApplicationContextManager _applicationContextManager;
    private BundleContext _bundleContext;
    private DeploymentManifestManager deploymentManifestManager;
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.application.management.impl");

    public void setApplicationMetadataFactory(ApplicationMetadataFactory amf) {
        this._applicationMetadataFactory = amf;
    }

    public void setDeploymentMetadataFactory(DeploymentMetadataFactory dmf) {
        this._deploymentMetadataFactory = dmf;
    }

    public void setBundleConverters(List<BundleConverter> bcs) {
        this._bundleConverters = bcs;
    }

    public void setDeploymentManifestManager(DeploymentManifestManager dm) {
        this.deploymentManifestManager = dm;
    }

    public void setLocalPlatform(LocalPlatform lp) {
        this._localPlatform = lp;
    }

    public void setApplicationContextManager(AriesApplicationContextManager acm) {
        this._applicationContextManager = acm;
    }

    public void setBundleContext(BundleContext b) {
        this._bundleContext = b;
    }

    public AriesApplication createApplication(IDirectory ebaFile) throws ManagementException {
        ApplicationMetadata applicationMetadata = null;
        DeploymentMetadata deploymentMetadata = null;
        HashMap<String, BundleConversion> modifiedBundles = new HashMap<String, BundleConversion>();
        AriesApplicationImpl application = null;
        String appPath = ebaFile.toString();
        try {
            Manifest applicationManifest = this.parseApplicationManifest(ebaFile);
            String appName = applicationManifest.getMainAttributes().getValue("Application-Name");
            if (appName == null || appName.isEmpty()) {
                String fullPath = appPath;
                if (fullPath.endsWith("/")) {
                    fullPath = fullPath.substring(0, fullPath.length() - 1);
                }
                int last_slash = fullPath.lastIndexOf("/");
                appName = fullPath.substring(last_slash + 1, fullPath.length());
            }
            IFile deploymentManifest = ebaFile.getFile("META-INF/DEPLOYMENT.MF");
            HashSet<BundleInfo> extraBundlesInfo = new HashSet<BundleInfo>();
            for (IFile f : ebaFile) {
                BundleManifest bm;
                if (f.isDirectory() || (bm = this.getBundleManifest(f)) == null) continue;
                if (bm.isValid()) {
                    extraBundlesInfo.add((BundleInfo)new SimpleBundleInfo(bm, f.toURL().toExternalForm()));
                    continue;
                }
                if (deploymentManifest != null) continue;
                BundleConversion convertedBinary = null;
                Iterator<BundleConverter> converters = this._bundleConverters.iterator();
                List<ConversionException> conversionExceptions = Collections.emptyList();
                while (converters.hasNext() && convertedBinary == null) {
                    try {
                        convertedBinary = converters.next().convert(ebaFile, f);
                    }
                    catch (ServiceException sx) {
                    }
                    catch (ConversionException cx) {
                        conversionExceptions.add(cx);
                    }
                }
                if (conversionExceptions.size() > 0) {
                    for (ConversionException cx : conversionExceptions) {
                        _logger.error("APPMANAGEMENT0004E", new Object[]{f.getName(), appName, cx});
                    }
                    throw new ManagementException(MessageUtil.getMessage("APPMANAGEMENT0005E", appName));
                }
                if (convertedBinary == null) continue;
                modifiedBundles.put(f.getName(), convertedBinary);
                extraBundlesInfo.add(convertedBinary.getBundleInfo());
            }
            if (applicationManifest.getMainAttributes().getValue("Application-Content") == null) {
                String appContent = this.buildAppContent(extraBundlesInfo);
                applicationManifest.getMainAttributes().putValue("Application-Content", appContent);
            }
            ManifestDefaultsInjector.updateManifest((Manifest)applicationManifest, (String)appName, (IDirectory)ebaFile);
            applicationMetadata = this._applicationMetadataFactory.createApplicationMetadata(applicationManifest);
            if (deploymentManifest != null) {
                String depSymbolicName;
                deploymentMetadata = this._deploymentMetadataFactory.parseDeploymentMetadata(deploymentManifest);
                String appSymbolicName = applicationMetadata.getApplicationSymbolicName();
                if (!appSymbolicName.equals(depSymbolicName = deploymentMetadata.getApplicationSymbolicName())) {
                    throw new ManagementException(MessageUtil.getMessage("APPMANAGEMENT0002E", appName, appSymbolicName, depSymbolicName));
                }
            }
            application = new AriesApplicationImpl(applicationMetadata, extraBundlesInfo, this._localPlatform);
            application.setDeploymentMetadata(deploymentMetadata);
            application.setModifiedBundles(modifiedBundles);
        }
        catch (IOException iox) {
            _logger.error("APPMANAGEMENT0006E", new Object[]{appPath, iox});
            throw new ManagementException((Exception)iox);
        }
        return application;
    }

    private String buildAppContent(Set<BundleInfo> bundleInfos) {
        StringBuilder builder = new StringBuilder();
        Iterator<BundleInfo> iterator = bundleInfos.iterator();
        while (iterator.hasNext()) {
            BundleInfo info = iterator.next();
            builder.append(info.getSymbolicName());
            if (info.getVersion() != null) {
                String version = info.getVersion().toString();
                builder.append(";version=\"[");
                builder.append(version);
                builder.append(',');
                builder.append(version);
                builder.append("]\"");
            }
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public AriesApplication createApplication(URL url) throws ManagementException {
        FileOutputStream os = null;
        AriesApplication app = null;
        try {
            File tempFile = this._localPlatform.getTemporaryFile();
            InputStream is = url.openStream();
            os = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            IDirectory downloadedSource = FileSystem.getFSRoot((File)tempFile);
            app = this.createApplication(downloadedSource);
        }
        catch (IOException iox) {
            try {
                throw new ManagementException((Exception)iox);
            }
            catch (Throwable throwable) {
                IOUtils.close(os);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)os);
        return app;
    }

    public AriesApplication resolve(AriesApplication originalApp, ResolveConstraint ... constraints) throws ResolverException {
        AriesApplicationImpl application = new AriesApplicationImpl(originalApp.getApplicationMetadata(), originalApp.getBundleInfo(), this._localPlatform);
        Manifest deploymentManifest = this.deploymentManifestManager.generateDeploymentManifest(originalApp, constraints);
        try {
            application.setDeploymentMetadata(this._deploymentMetadataFactory.createDeploymentMetadata(deploymentManifest));
        }
        catch (IOException ioe) {
            throw new ResolverException((Exception)ioe);
        }
        if (originalApp instanceof AriesApplicationImpl) {
            application.setModifiedBundles(((AriesApplicationImpl)originalApp).getModifiedBundles());
        }
        return application;
    }

    public AriesApplicationContext install(AriesApplication app) throws BundleException, ManagementException, ResolverException {
        if (!app.isResolved()) {
            app = this.resolve(app, new ResolveConstraint[0]);
        }
        String appScope = app.getApplicationMetadata().getApplicationScope();
        ServiceReference[] ref = null;
        try {
            String filter = "(repositoryScope=" + appScope + ")";
            ref = this._bundleContext.getServiceReferences(BundleRepository.class.getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (ref == null || ref.length == 0) {
            Hashtable<String, String> dict = new Hashtable<String, String>();
            ((Dictionary)dict).put("repositoryScope", appScope);
            this._bundleContext.registerService(BundleRepository.class.getName(), (Object)new ApplicationRepository(app), dict);
        }
        AriesApplicationContext result = this._applicationContextManager.getApplicationContext(app);
        return result;
    }

    public void uninstall(AriesApplicationContext app) throws BundleException {
        this._applicationContextManager.remove(app);
    }

    public void addApplicationListener(AriesApplicationListener l) {
    }

    public void removeApplicationListener(AriesApplicationListener l) {
    }

    private Manifest parseApplicationManifest(IDirectory source) throws IOException {
        Manifest result = new Manifest();
        IFile f = source.getFile("META-INF/APPLICATION.MF");
        if (f != null) {
            InputStream is = null;
            try {
                is = f.open();
                result = ManifestProcessor.parseManifest((InputStream)is);
            }
            catch (IOException iox) {
                _logger.error("APPMANAGEMENT0007E", new Object[]{source.getName(), iox});
                throw iox;
            }
            finally {
                IOUtils.close((Closeable)is);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleManifest getBundleManifest(IFile file) throws IOException {
        BundleManifest mf = null;
        InputStream in = null;
        try {
            in = file.open();
            mf = BundleManifest.fromBundle((InputStream)in);
        }
        finally {
            IOUtils.close((Closeable)in);
        }
        return mf;
    }

    public AriesApplicationContext update(AriesApplication app, DeploymentMetadata depMf) throws UpdateException {
        if (!(app instanceof AriesApplicationImpl)) {
            throw new IllegalArgumentException("Argument is not AriesApplication created by this manager");
        }
        if (!app.getApplicationMetadata().getApplicationSymbolicName().equals(depMf.getApplicationSymbolicName()) || !app.getApplicationMetadata().getApplicationVersion().equals((Object)depMf.getApplicationVersion())) {
            throw new IllegalArgumentException("The deployment metadata does not match the application.");
        }
        DeploymentMetadata oldMetadata = app.getDeploymentMetadata();
        AriesApplicationContext foundCtx = null;
        for (AriesApplicationContext ctx : this._applicationContextManager.getApplicationContexts()) {
            if (!ctx.getApplication().equals(app)) continue;
            foundCtx = ctx;
            break;
        }
        ((AriesApplicationImpl)app).setDeploymentMetadata(depMf);
        if (foundCtx != null) {
            try {
                return this._applicationContextManager.update(app, oldMetadata);
            }
            catch (UpdateException ue) {
                if (ue.hasRolledBack()) {
                    ((AriesApplicationImpl)app).setDeploymentMetadata(oldMetadata);
                }
                throw ue;
            }
        }
        return null;
    }
}

