/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.modelling.DeployedBundles;
import org.apache.aries.application.modelling.DeploymentMFElement;
import org.apache.aries.application.modelling.ExportedBundle;
import org.apache.aries.application.modelling.ExportedPackage;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.modelling.ImportedPackage;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.Provider;
import org.apache.aries.application.modelling.internal.MessageUtil;
import org.apache.aries.application.modelling.internal.PackageRequirementMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeployedBundlesImpl
implements DeployedBundles {
    private final Logger logger = LoggerFactory.getLogger(DeployedBundlesImpl.class);
    private final String assetName;
    private final Set<ImportedBundle> appContent = new HashSet<ImportedBundle>();
    private final Set<ImportedBundle> appUseBundle = new HashSet<ImportedBundle>();
    private final Set<ModelledResource> deployedContent = new HashSet<ModelledResource>();
    private final Set<ModelledResource> deployedUseBundle = new HashSet<ModelledResource>();
    private final Set<ModelledResource> deployedProvisionBundle = new HashSet<ModelledResource>();
    private final Collection<ImportedService> deployedImportService = new HashSet<ImportedService>();
    private final Collection<ModelledResource> fakeDeployedBundles = new HashSet<ModelledResource>();

    public DeployedBundlesImpl(String assetName, Collection<ImportedBundle> appContentNames, Collection<ImportedBundle> appUseBundleNames, Collection<ModelledResource> fakeServiceProvidingBundles) {
        this.logger.debug("Method entry: {}, args {}", (Object)"DeployedBundles", (Object)new Object[]{appContentNames, appUseBundleNames, fakeServiceProvidingBundles});
        this.assetName = assetName;
        this.appContent.addAll(appContentNames);
        this.appUseBundle.addAll(appUseBundleNames);
        if (fakeServiceProvidingBundles != null) {
            this.fakeDeployedBundles.addAll(fakeServiceProvidingBundles);
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"DeployedBundles");
    }

    public void addBundle(ModelledResource modelledBundle) {
        this.logger.debug("Method entry: {}, args {}", (Object)"addBundle", (Object)new Object[]{modelledBundle});
        ExportedBundle resolvedBundle = modelledBundle.getExportedBundle();
        if (this.isBundleMatch(this.appContent, resolvedBundle)) {
            this.logger.debug("Added to Deployed-Content: " + resolvedBundle);
            this.deployedContent.add(modelledBundle);
            this.deployedImportService.addAll(modelledBundle.getImportedServices());
        } else if (this.isBundleMatch(this.appUseBundle, resolvedBundle)) {
            this.logger.debug("Added to Deployed-Use-Bundle: " + resolvedBundle);
            this.deployedUseBundle.add(modelledBundle);
        } else {
            this.logger.debug("Added to Provision-Bundle: " + resolvedBundle);
            this.deployedProvisionBundle.add(modelledBundle);
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"addBundle");
    }

    private boolean isBundleMatch(Set<ImportedBundle> imports, ExportedBundle potentialMatch) {
        boolean result = false;
        for (ImportedBundle ib : imports) {
            if (!ib.isSatisfied((Provider)potentialMatch)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getContent() {
        return this.createManifestString(this.deployedContent);
    }

    public String getUseBundle() {
        return this.createManifestString(this.deployedUseBundle);
    }

    public String getProvisionBundle() {
        return this.createManifestString(this.deployedProvisionBundle);
    }

    public String getImportPackage() throws ResolverException {
        this.logger.debug("Method entry: {}, args {}", (Object)"getImportPackage");
        ArrayList<ImportedPackage> externalReqs = new ArrayList<ImportedPackage>(this.getExternalPackageRequirements());
        this.validateOtherImports(externalReqs);
        HashMap<ImportedPackage, ExportedPackage> useBundlePkgs = new HashMap<ImportedPackage, ExportedPackage>();
        Iterator iter = externalReqs.iterator();
        while (iter.hasNext()) {
            ImportedPackage req = (ImportedPackage)iter.next();
            ExportedPackage match = this.getPackageMatch(req, this.deployedUseBundle);
            if (match == null) continue;
            useBundlePkgs.put(req, match);
            iter.remove();
        }
        StringBuilder useBundleImports = new StringBuilder();
        for (Map.Entry entry : useBundlePkgs.entrySet()) {
            useBundleImports.append(((ExportedPackage)entry.getValue()).toDeploymentString());
            ImportedPackage key = (ImportedPackage)entry.getKey();
            if (key.isOptional()) {
                useBundleImports.append(";resolution:=optional");
            }
            useBundleImports.append(",");
        }
        String result = useBundleImports.toString() + this.createManifestString(externalReqs);
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"getImportPackage", (Object)result);
        return result;
    }

    public String getDeployedImportService() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getDeployedImportService");
        ArrayList<ImportedService> deployedBundleServiceImports = new ArrayList<ImportedService>();
        ArrayList servicesExportedWithinIsolatedContent = new ArrayList();
        for (ModelledResource mRes : this.getDeployedContent()) {
            servicesExportedWithinIsolatedContent.addAll(mRes.getExportedServices());
        }
        for (ModelledResource mRes : this.fakeDeployedBundles) {
            servicesExportedWithinIsolatedContent.addAll(mRes.getExportedServices());
        }
        for (ImportedService impService : this.deployedImportService) {
            boolean serviceProvidedWithinIsolatedContent;
            ExportedService svc;
            if (impService.isMultiple()) {
                deployedBundleServiceImports.add(impService);
                continue;
            }
            Iterator it = servicesExportedWithinIsolatedContent.iterator();
            for (serviceProvidedWithinIsolatedContent = false; !serviceProvidedWithinIsolatedContent && it.hasNext(); serviceProvidedWithinIsolatedContent |= impService.isSatisfied((Provider)svc)) {
                svc = (ExportedService)it.next();
            }
            if (serviceProvidedWithinIsolatedContent) continue;
            deployedBundleServiceImports.add(impService);
        }
        String result = this.createManifestString(deployedBundleServiceImports);
        this.logger.debug("Method exit: {}, returning {}", (Object)"getDeployedImportService", (Object)result);
        return result;
    }

    private Collection<ImportedPackage> getExternalPackageRequirements() throws ResolverException {
        this.logger.debug("Method entry: {}, args {}", (Object)"getExternalPackageRequirements");
        ArrayList requirements = new ArrayList();
        for (ModelledResource bundle : this.deployedContent) {
            requirements.addAll(bundle.getImportedPackages());
        }
        Collection<ImportedPackage> result = new ArrayList<ImportedPackage>();
        for (ImportedPackage req : requirements) {
            ExportedPackage match = this.getPackageMatch(req, this.deployedContent);
            if (match != null) continue;
            result.add(req);
        }
        PackageRequirementMerger merger = new PackageRequirementMerger(result);
        if (!merger.isMergeSuccessful()) {
            ArrayList<String> pkgNames = new ArrayList<String>(merger.getInvalidRequirements());
            StringBuilder buff = new StringBuilder();
            for (String pkgName : merger.getInvalidRequirements()) {
                buff.append(pkgName).append(", ");
            }
            int buffLen = buff.length();
            String pkgString = buffLen > 0 ? buff.substring(0, buffLen - 2) : "";
            ResolverException re = new ResolverException(MessageUtil.getMessage("INCOMPATIBLE_PACKAGE_VERSION_REQUIREMENTS", this.assetName, pkgString));
            re.setUnsatisfiedRequirements(pkgNames);
            this.logger.debug("Method exit: {}, returning {}", (Object)"getExternalPackageRequirements", (Object)re);
            throw re;
        }
        result = merger.getMergedRequirements();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getExternalPackageRequirements", result);
        return result;
    }

    private void validateOtherImports(Collection<ImportedPackage> requirements) throws ResolverException {
        this.logger.debug("Method entry: {}, args {}", (Object)"validateOtherImports", requirements);
        for (ImportedPackage req : requirements) {
            String pkgName = req.getPackageName();
            for (String name : req.getAttributes().keySet()) {
                if (!"bundle-symbolic-name".equals(name) && !"bundle-version".equals(name)) continue;
                ResolverException re = new ResolverException(MessageUtil.getMessage("INVALID_PACKAGE_REQUIREMENT_ATTRIBUTES", this.assetName, name, pkgName));
                re.setUnsatisfiedRequirements(Arrays.asList(pkgName));
                this.logger.debug("Method exit: {}, returning {}", (Object)"validateOtherImports", (Object)re);
                throw re;
            }
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"validateOtherImports");
    }

    private ExportedPackage getPackageMatch(ImportedPackage requirement, Collection<ModelledResource> bundles) {
        this.logger.debug("Method entry: {}, args {}", (Object)"getPackageMatch", (Object)new Object[]{requirement, bundles});
        ExportedPackage result = null;
        block0: for (ModelledResource bundle : bundles) {
            for (ExportedPackage pkg : bundle.getExportedPackages()) {
                if (!requirement.isSatisfied((Provider)pkg)) continue;
                result = pkg;
                break block0;
            }
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"getPackageMatch", (Object)new Object[]{result});
        return result;
    }

    private String createManifestString(Collection<? extends DeploymentMFElement> values) {
        this.logger.debug("Method entry: {}, args {}", (Object)"createManifestString", (Object)new Object[]{values});
        StringBuilder builder = new StringBuilder();
        for (DeploymentMFElement deploymentMFElement : values) {
            builder.append(deploymentMFElement.toDeploymentString()).append(",");
        }
        int length = builder.length();
        String string = length > 0 ? builder.substring(0, length - 1) : "";
        this.logger.debug("Method exit: {}, returning {}", (Object)"createManifestString", (Object)new Object[]{string});
        return string;
    }

    public String toString() {
        return "Deployed-Content=" + this.deployedContent + ' ' + "Deployed-Use-Bundle" + '=' + this.deployedUseBundle + ' ' + "Provision-Bundle" + '=' + this.deployedProvisionBundle;
    }

    public Collection<ModelledResource> getDeployedContent() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getDeployedContent");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getDeployedContent", this.deployedContent);
        return Collections.unmodifiableCollection(this.deployedContent);
    }

    public Collection<ModelledResource> getDeployedProvisionBundle() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getDeployedProvisionBundle");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getDeployedProvisionBundle", this.deployedContent);
        return Collections.unmodifiableCollection(this.deployedProvisionBundle);
    }

    public Collection<ModelledResource> getRequiredUseBundle() throws ResolverException {
        this.logger.debug("Method entry: {}, args {}", (Object)"getRequiredUseBundle");
        Collection<ImportedPackage> externalReqs = this.getExternalPackageRequirements();
        HashSet<ModelledResource> usedUseBundles = new HashSet<ModelledResource>();
        for (ImportedPackage req : externalReqs) {
            ExportedPackage match = this.getPackageMatch(req, this.deployedUseBundle);
            if (match == null) continue;
            usedUseBundles.add(match.getBundle());
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"getRequiredUseBundle", usedUseBundles);
        return usedUseBundles;
    }

    public Map<String, String> getExtraHeaders() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getExtraHeaders");
        Map<String, String> result = Collections.emptyMap();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getExtraHeaders", result);
        return result;
    }
}

