/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.application.modelling.ExportedPackage;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ResourceType;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportedPackageImpl
implements ExportedPackage {
    private static final String PACKAGE_SPECIFICATION_VERSION = "specification-version";
    private final Map<String, Object> _attributes;
    private final String _packageName;
    private final String _version;
    private final ModelledResource _bundle;
    private final Logger logger = LoggerFactory.getLogger(ExportedPackageImpl.class);

    public ExportedPackageImpl(ModelledResource mr, String pkg, Map<String, Object> attributes) {
        this.logger.debug("Method entry: {}, args {}", (Object)"ExportedPackageImpl", (Object)new Object[]{mr, pkg, attributes});
        this._attributes = new HashMap<String, Object>(attributes);
        this._packageName = pkg;
        this._attributes.put(ResourceType.PACKAGE.toString(), this._packageName);
        String version = (String)attributes.get("version");
        this._version = version == null || "".equals(version) ? Version.emptyVersion.toString() : version;
        this._attributes.put("version", this._version);
        this._attributes.put("bundle-symbolic-name", mr.getSymbolicName());
        this._attributes.put("bundle-version", mr.getVersion());
        this._bundle = mr;
        this.logger.debug("Method exit: {}, returning {}", (Object)"ExportedPackageImpl");
    }

    public Map<String, Object> getAttributes() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getAttributes");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getAttributes", this._attributes);
        return Collections.unmodifiableMap(this._attributes);
    }

    public ResourceType getType() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getType");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getType", (Object)ResourceType.PACKAGE);
        return ResourceType.PACKAGE;
    }

    public String getPackageName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getPackageName");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getPackageName", (Object)this._packageName);
        return this._packageName;
    }

    public String getVersion() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getVersion");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getVersion", (Object)this._version);
        return this._version;
    }

    public String toDeploymentString() {
        this.logger.debug("Method entry: {}, args {}", (Object)"toDeploymentString");
        StringBuilder sb = new StringBuilder(this._packageName);
        for (Map.Entry<String, Object> entry : this._attributes.entrySet()) {
            String key = entry.getKey();
            Object objectValue = entry.getValue();
            if (objectValue.getClass().isArray()) continue;
            String value = String.valueOf(objectValue);
            if (key != null && !key.equals(ResourceType.PACKAGE.toString()) && !key.equals(PACKAGE_SPECIFICATION_VERSION)) {
                if (key.equals("bundle-version")) {
                    value = "[" + value + "," + value + "]";
                }
                if (key.equals("") || key.endsWith(":") || value == null || value.equals("")) {
                    this.logger.debug("ExportedPackageImpl.toDeploymentString ignored " + key + "=" + value);
                    continue;
                }
                sb.append(";").append(key).append("=\"").append(value).append('\"');
                continue;
            }
            this.logger.debug("ExportedPackageImpl.toDeploymentString() ignoring attribute " + key + "->" + value);
        }
        String result = sb.toString();
        this.logger.debug("Method exit: {}, returning {}", (Object)"toDeploymentString", (Object)result);
        return result;
    }

    public ModelledResource getBundle() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getBundle");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getBundle", (Object)this._bundle);
        return this._bundle;
    }

    public String toString() {
        return this.toDeploymentString();
    }
}

