/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ResourceType;
import org.apache.aries.application.modelling.WrappedServiceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportedServiceImpl
implements ExportedService {
    private final Logger logger = LoggerFactory.getLogger(ExportedServiceImpl.class);
    private final Map<String, Object> _attributes;
    private final Collection<String> _interfaces;
    private final Map<String, Object> _serviceProperties;
    private final String _name;
    private final int _ranking;
    private String _toString = null;

    public ExportedServiceImpl(String name, int ranking, Collection<String> ifaces, Map<String, Object> serviceProperties) {
        this.logger.debug("Method entry: {}, args {}", (Object)"ExportedServiceImpl", (Object)new Object[]{name, ranking, ifaces});
        this._interfaces = new TreeSet<String>(ifaces);
        this._name = !"".equals(name) ? name : null;
        this._ranking = ranking;
        this._serviceProperties = serviceProperties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(serviceProperties);
        this._attributes = new HashMap<String, Object>(this._serviceProperties);
        StringBuilder sb = new StringBuilder();
        for (String i : this._interfaces) {
            sb.append(i + ",");
        }
        sb = sb.deleteCharAt(sb.length() - 1);
        this._attributes.put("objectClass", sb.toString());
        this._attributes.put("service.ranking", String.valueOf(this._ranking));
        this._attributes.put("service", "service");
        this.logger.debug("Method exit: {}, returning {}", (Object)"ExportedServiceImpl");
    }

    @Deprecated
    public ExportedServiceImpl(String ifaceName, Map<String, String> attrs) {
        this.logger.debug("Method entry: {}, args {}", (Object)"ExportedServiceImpl", (Object)new Object[]{ifaceName, attrs});
        this._interfaces = new TreeSet<String>(Arrays.asList(ifaceName));
        this._ranking = 0;
        this._attributes = new HashMap<String, String>(attrs);
        this._attributes.put("objectClass", ifaceName);
        this._attributes.put("service.ranking", String.valueOf(this._ranking));
        this._attributes.put("service", "service");
        this._serviceProperties = new HashMap<String, Object>();
        this._name = null;
        this.logger.debug("Method exit: {}, returning {}", (Object)"ExportedServiceImpl");
    }

    public Map<String, Object> getAttributes() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getAttributes");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getAttributes", this._attributes);
        return Collections.unmodifiableMap(this._attributes);
    }

    public ResourceType getType() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getType");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getType", (Object)ResourceType.SERVICE);
        return ResourceType.SERVICE;
    }

    public Collection<String> getInterfaces() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getInterfaces");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getInterfaces", this._interfaces);
        return Collections.unmodifiableCollection(this._interfaces);
    }

    public String getName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getName");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getName", (Object)this._name);
        return this._name;
    }

    public int getRanking() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getRanking");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getRanking", (Object)this._ranking);
        return this._ranking;
    }

    public Map<String, Object> getServiceProperties() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getServiceProperties");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getServiceProperties", this._serviceProperties);
        return Collections.unmodifiableMap(this._serviceProperties);
    }

    public int compareTo(WrappedServiceMetadata o) {
        this.logger.debug("Method entry: {}, args {}", (Object)"compareTo", (Object)o);
        if (o == null) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"compareTo", (Object)-1);
            return -1;
        }
        int result = this.toString().compareTo(o.toString());
        this.logger.debug("Method exit: {}, returning {}", (Object)"compareTo", (Object)result);
        return result;
    }

    public boolean equals(Object o) {
        this.logger.debug("Method entry: {}, args {}", (Object)"equals", o);
        if (!(o instanceof WrappedServiceMetadata)) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"equals", (Object)false);
            return false;
        }
        if (o == this) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"equals", (Object)true);
            return true;
        }
        boolean eq = this.toString().equals(o.toString());
        this.logger.debug("Method exit: {}, returning {}", (Object)"equals", (Object)eq);
        return eq;
    }

    public int hashCode() {
        this.logger.debug("Method entry: {}, args {}", (Object)"hashCode");
        int result = this.toString().hashCode();
        this.logger.debug("Method exit: {}, returning {}", (Object)"hashCode", (Object)result);
        return result;
    }

    public String toString() {
        if (this._toString != null) {
            return this._toString;
        }
        ArrayList<String> interfaces = new ArrayList<String>(this._interfaces);
        Collections.sort(interfaces);
        ArrayList<String> props = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this._serviceProperties.entrySet()) {
            String entryText;
            Object entryValue = entry.getValue();
            if (entryValue.getClass().isArray()) {
                Object[] entryArray = (Object[])entryValue;
                StringBuilder sb = new StringBuilder();
                for (Object o : entryArray) {
                    sb.append(String.valueOf(o) + ",");
                }
                sb = sb.deleteCharAt(sb.length() - 1);
                entryText = sb.toString();
            } else {
                entryText = String.valueOf(entryValue);
            }
            props.add("<entry> key=\"" + entry.getKey() + "\" value=\"" + entryText + "\"/>");
        }
        Collections.sort(props);
        StringBuffer buf = new StringBuffer("<service>");
        if (this._name != null) {
            buf.append("<name>" + this._name + "</name>");
        }
        if (this._interfaces.size() > 0) {
            buf.append("<interfaces>");
        }
        for (String i : interfaces) {
            buf.append("<value>" + i + "</value>");
        }
        if (this._interfaces.size() > 0) {
            buf.append("</interfaces>");
        }
        if (this._serviceProperties.size() > 0) {
            buf.append("<service-properties>");
        }
        for (String p : props) {
            buf.append(p);
        }
        if (this._serviceProperties.size() > 0) {
            buf.append("</service-properties>");
        }
        buf.append("</service>");
        this._toString = buf.toString();
        return this._toString;
    }

    public boolean identicalOrDiffersOnlyByName(WrappedServiceMetadata wsmi) {
        this.logger.debug("Method entry: {}, args {}", (Object)"identicalOrDiffersOnlyByName", (Object)wsmi);
        if (this.equals(wsmi)) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"identicalOrDiffersOnlyByName", (Object)true);
            return true;
        }
        HashSet<String> myInterfaces = new HashSet<String>(this._interfaces);
        HashSet cmpInterfaces = new HashSet(wsmi.getInterfaces());
        if (!((Object)myInterfaces).equals(cmpInterfaces)) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"identicalOrDiffersOnlyByName", (Object)false);
            return false;
        }
        boolean propertiesEqual = ((Object)this._serviceProperties).equals(wsmi.getServiceProperties());
        if (!propertiesEqual) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"identicalOrDiffersOnlyByName", (Object)false);
            return false;
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"identicalOrDiffersOnlyByName", (Object)true);
        return true;
    }
}

