/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.modelling.Provider;
import org.apache.aries.application.modelling.ResourceType;
import org.apache.aries.application.modelling.utils.impl.ModellingHelperImpl;
import org.apache.aries.application.utils.FilterUtils;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportedBundleImpl
implements ImportedBundle {
    private final Map<String, String> _attributes;
    private final String _filterString;
    private final Filter _filter;
    private final Logger logger = LoggerFactory.getLogger(ImportedBundleImpl.class);

    public ImportedBundleImpl(String filterString, Map<String, String> attributes) throws InvalidAttributeException {
        this.logger.debug("Method entry: {}, args {}", (Object)"ImportedBundleImpl", (Object)new Object[]{filterString, attributes});
        this._attributes = new HashMap<String, String>(attributes);
        String versionRange = this._attributes.remove("bundle-version");
        if (versionRange == null) {
            versionRange = Version.emptyVersion.toString();
        }
        if (this._attributes.get("version") == null) {
            this._attributes.put("version", versionRange);
        }
        this._filterString = filterString;
        try {
            this._filter = FrameworkUtil.createFilter((String)FilterUtils.removeMandatoryFilterToken((String)this._filterString));
        }
        catch (InvalidSyntaxException isx) {
            InvalidAttributeException iax = new InvalidAttributeException((Exception)((Object)isx));
            this.logger.debug("Method exit: {}, returning {}", (Object)"ImportedBundleImpl", (Object)new Object[]{iax});
            throw iax;
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"ImportedBundleImpl");
    }

    public ImportedBundleImpl(String bundleName, String versionRange) throws InvalidAttributeException {
        this.logger.debug("Method entry: {}, args {}", (Object)"ImportedBundleImpl", (Object)new Object[]{bundleName, versionRange});
        this._attributes = new HashMap<String, String>();
        this._attributes.put("symbolicname", bundleName);
        this._attributes.put("version", versionRange);
        this._filterString = ManifestHeaderProcessor.generateFilter(this._attributes);
        try {
            this._filter = FrameworkUtil.createFilter((String)FilterUtils.removeMandatoryFilterToken((String)this._filterString));
        }
        catch (InvalidSyntaxException isx) {
            InvalidAttributeException iax = new InvalidAttributeException((Exception)((Object)isx));
            this.logger.debug("Method entry: {}, args {}", (Object)"ImportedBundleImpl", (Object)new Object[]{iax});
            throw iax;
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"ImportedBundleImpl");
    }

    public String getAttributeFilter() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getAttributeFilter");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getAttributeFilter", (Object)new Object[]{this._filterString});
        return this._filterString;
    }

    public ResourceType getType() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getType");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getType", (Object)new Object[]{ResourceType.BUNDLE});
        return ResourceType.BUNDLE;
    }

    public boolean isMultiple() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isMultiple");
        this.logger.debug("Method exit: {}, returning {}", (Object)"isMultiple", (Object)new Object[]{false});
        return false;
    }

    public boolean isOptional() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isOptional");
        boolean optional = false;
        if (this._attributes.containsKey("resolution:") && "optional".equals(this._attributes.get("resolution:"))) {
            optional = true;
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"isOptional", (Object)optional);
        return optional;
    }

    public boolean isSatisfied(Provider capability) {
        boolean allPresent;
        this.logger.debug("Method entry: {}, args {}", (Object)"isSatisfied", (Object)capability);
        if (capability.getType() != ResourceType.BUNDLE && capability.getType() != ResourceType.COMPOSITE) {
            this.logger.debug("Method exit: {}, returning {}", (Object)"isSatisfied", (Object)false);
            return false;
        }
        Hashtable<String, Version> dict = new Hashtable<String, Version>(capability.getAttributes());
        String version = (String)((Dictionary)dict).get("version");
        if (version != null) {
            ((Dictionary)dict).put("version", Version.parseVersion((String)version));
        }
        boolean result = (allPresent = ModellingHelperImpl.areMandatoryAttributesPresent_(this._attributes, capability)) && this._filter.match(dict);
        this.logger.debug("Method exit: {}, returning {}", (Object)"isSatisfied", (Object)result);
        return result;
    }

    public String getVersionRange() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getVersionRange");
        String range = this._attributes.get("version");
        String result = range == null ? Version.emptyVersion.toString() : range;
        this.logger.debug("Method exit: {}, returning {}", (Object)"getVersionRange", (Object)result);
        return result;
    }

    public String getSymbolicName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getSymbolicName");
        String result = this._attributes.get("symbolicname");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getSymbolicName", (Object)result);
        return result;
    }

    public boolean equals(Object o) {
        this.logger.debug("Method entry: {}, args {}", (Object)"equals", o);
        boolean result = false;
        if (o == this) {
            result = true;
        } else if (o instanceof ImportedBundleImpl) {
            ImportedBundleImpl ib = (ImportedBundleImpl)o;
            result = this.getSymbolicName().equals(ib.getSymbolicName()) && this.getVersionRange().equals(ib.getVersionRange());
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"equals", (Object)result);
        return result;
    }

    public int hashCode() {
        this.logger.debug("Method entry: {}, args {}", (Object)"hashCode");
        int hashCode = this.getSymbolicName().hashCode() + 31 * this.getVersionRange().hashCode();
        this.logger.debug("Method entry: {}, args {}", (Object)"hashCode", (Object)hashCode);
        return hashCode;
    }

    public String toString() {
        return this._filterString;
    }
}

