/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.modelling.ExportedBundle;
import org.apache.aries.application.modelling.ExportedPackage;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.modelling.ImportedPackage;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ResourceType;
import org.apache.aries.application.modelling.impl.ExportedBundleImpl;
import org.apache.aries.application.modelling.impl.ExportedPackageImpl;
import org.apache.aries.application.modelling.impl.ExportedServiceImpl;
import org.apache.aries.application.modelling.impl.ImportedBundleImpl;
import org.apache.aries.application.modelling.impl.ImportedPackageImpl;
import org.apache.aries.application.modelling.impl.ImportedServiceImpl;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelledResourceImpl
implements ModelledResource {
    private final Logger logger = LoggerFactory.getLogger(ModelledResourceImpl.class);
    private final String _fileURI;
    private final Collection<ImportedService> _importedServices;
    private final Collection<ExportedService> _exportedServices;
    private final Collection<ExportedPackage> _exportedPackages;
    private final Collection<ImportedPackage> _importedPackages;
    private final Collection<ImportedBundle> _requiredBundles;
    private final ExportedBundle _exportedBundle;
    private final ResourceType _resourceType;

    public ModelledResourceImpl(String fileURI, BundleInfo bundleInfo, Collection<ImportedService> importedServices, Collection<ExportedService> exportedServices) throws InvalidAttributeException {
        this(fileURI, bundleInfo.getRawAttributes(), importedServices, exportedServices);
    }

    public ModelledResourceImpl(String fileURI, Attributes bundleAttributes, ExportedBundle exportedBundle, ResourceType resourceType, Collection<ImportedService> importedServices, Collection<ExportedService> exportedServices) throws InvalidAttributeException {
        this(fileURI, bundleAttributes, resourceType, exportedBundle, importedServices, exportedServices);
        this.logger.debug("Method entry: {}, args {}", (Object)"ModelledResourceImpl", (Object)new Object[]{fileURI, bundleAttributes, importedServices, exportedServices});
        this.logger.debug("Method exit: {}, returning {}", (Object)"ModelledResourceImpl");
    }

    public ModelledResourceImpl(String fileURI, Attributes bundleAttributes, Collection<ImportedService> importedServices, Collection<ExportedService> exportedServices) throws InvalidAttributeException {
        this(fileURI, bundleAttributes, ResourceType.BUNDLE, null, importedServices, exportedServices);
        this.logger.debug("Method entry: {}, args {}", (Object)"ModelledResourceImpl", (Object)new Object[]{fileURI, bundleAttributes, importedServices, exportedServices});
        this.logger.debug("Method exit: {}, returning {}", (Object)"ModelledResourceImpl");
    }

    public ModelledResourceImpl(String fileURI, Attributes bundleAttributes, ResourceType resourceType, ExportedBundle exportedBundle, Collection<ImportedService> importedServices, Collection<ExportedService> exportedServices) throws InvalidAttributeException {
        this.logger.debug("Method entry: {}, args {}", (Object)"ModelledResourceImpl", (Object)new Object[]{fileURI, bundleAttributes, importedServices, exportedServices, resourceType});
        this._exportedBundle = exportedBundle == null ? new ExportedBundleImpl(bundleAttributes) : exportedBundle;
        this._resourceType = resourceType;
        this._fileURI = fileURI;
        this._importedServices = importedServices != null ? new ArrayList<ImportedService>(importedServices) : new ArrayList<ImportedService>();
        this._exportedServices = exportedServices != null ? new ArrayList<ExportedService>(exportedServices) : new ArrayList<ExportedService>();
        this._exportedPackages = new ArrayList<ExportedPackage>();
        String packageExports = bundleAttributes.getValue("Export-Package");
        if (packageExports != null) {
            List exportedPackages = ManifestHeaderProcessor.parseExportString((String)packageExports);
            for (ManifestHeaderProcessor.NameValuePair exportedPackage : exportedPackages) {
                this._exportedPackages.add(new ExportedPackageImpl(this, (String)exportedPackage.getName(), new HashMap<String, Object>((Map)exportedPackage.getValue())));
            }
        }
        this._importedPackages = new ArrayList<ImportedPackage>();
        String packageImports = bundleAttributes.getValue("Import-Package");
        if (packageImports != null) {
            Map importedPackages = ManifestHeaderProcessor.parseImportString((String)packageImports);
            for (Map.Entry importedPackage : importedPackages.entrySet()) {
                Map atts = (Map)importedPackage.getValue();
                this._importedPackages.add(new ImportedPackageImpl((String)importedPackage.getKey(), atts));
            }
        }
        String serviceExports = null;
        if (this._resourceType == ResourceType.BUNDLE) {
            serviceExports = bundleAttributes.getValue("Export-Service");
        }
        if (serviceExports != null) {
            List expServices = ManifestHeaderProcessor.parseExportString((String)serviceExports);
            for (ManifestHeaderProcessor.NameValuePair exportedService : expServices) {
                this._exportedServices.add(new ExportedServiceImpl((String)exportedService.getName(), (Map)exportedService.getValue()));
            }
        }
        String serviceImports = null;
        if (this._resourceType == ResourceType.BUNDLE) {
            serviceImports = bundleAttributes.getValue("Import-Service");
        }
        if (serviceImports != null) {
            Map svcImports = ManifestHeaderProcessor.parseImportString((String)serviceImports);
            for (Map.Entry importedService : svcImports.entrySet()) {
                this._importedServices.add(new ImportedServiceImpl((String)importedService.getKey(), (Map)importedService.getValue()));
            }
        }
        this._requiredBundles = new ArrayList<ImportedBundle>();
        if (this._resourceType == ResourceType.BUNDLE) {
            String dynamicImports;
            String requireBundleHeader = bundleAttributes.getValue("Require-Bundle");
            if (requireBundleHeader != null) {
                Map requiredBundles = ManifestHeaderProcessor.parseImportString((String)requireBundleHeader);
                for (Map.Entry bundle : requiredBundles.entrySet()) {
                    String type = (String)bundle.getKey();
                    Map attribs = (Map)bundle.getValue();
                    String bundleVersion = (String)attribs.remove("bundle-version");
                    if (bundleVersion != null && attribs.get("version") == null) {
                        attribs.put("version", bundleVersion);
                    }
                    String filter = ManifestHeaderProcessor.generateFilter((String)"symbolicname", (String)type, (Map)attribs);
                    HashMap<String, String> atts = new HashMap<String, String>((Map)bundle.getValue());
                    atts.put("symbolicname", (String)bundle.getKey());
                    this._requiredBundles.add(new ImportedBundleImpl(filter, atts));
                }
            }
            if ((dynamicImports = bundleAttributes.getValue("DynamicImport-Package")) != null) {
                Map dynamicImportPackages = ManifestHeaderProcessor.parseImportString((String)dynamicImports);
                for (Map.Entry dynImportPkg : dynamicImportPackages.entrySet()) {
                    if (((String)dynImportPkg.getKey()).indexOf("*") != -1) continue;
                    ((ManifestHeaderProcessor.NameValueMap)dynImportPkg.getValue()).put((Object)"resolution:", (Object)"optional");
                    this._importedPackages.add(new ImportedPackageImpl((String)dynImportPkg.getKey(), (Map)dynImportPkg.getValue()));
                }
            }
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"ModelledResourceImpl");
    }

    public String getLocation() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getLocation");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getLocation", (Object)this._fileURI);
        return this._fileURI;
    }

    public ExportedBundle getExportedBundle() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getExportedBundle");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getExportedBundle", (Object)this._exportedBundle);
        return this._exportedBundle;
    }

    public Collection<ExportedPackage> getExportedPackages() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getExportedPackages");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getExportedPackages", this._exportedPackages);
        return Collections.unmodifiableCollection(this._exportedPackages);
    }

    public Collection<ImportedPackage> getImportedPackages() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getImportedPackages");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getImportedPackages", this._importedPackages);
        return Collections.unmodifiableCollection(this._importedPackages);
    }

    public Collection<ExportedService> getExportedServices() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getExportedServices");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getExportedServices", this._exportedServices);
        return Collections.unmodifiableCollection(this._exportedServices);
    }

    public Collection<ImportedService> getImportedServices() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getImportedServices");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getImportedServices", this._exportedServices);
        return Collections.unmodifiableCollection(this._importedServices);
    }

    public String getSymbolicName() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getSymbolicName");
        String result = this._exportedBundle.getSymbolicName();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getSymbolicName", (Object)result);
        return result;
    }

    public String getVersion() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getVersion");
        String result = this._exportedBundle.getVersion();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getVersion", (Object)result);
        return result;
    }

    public String toDeploymentString() {
        this.logger.debug("Method entry: {}, args {}", (Object)"toDeploymentString");
        String result = this._exportedBundle.toDeploymentString();
        this.logger.debug("Method exit: {}, returning {}", (Object)"toDeploymentString", (Object)result);
        return result;
    }

    public ResourceType getType() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getType");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getType", (Object)ResourceType.BUNDLE);
        return this._resourceType;
    }

    public String toString() {
        return this.toDeploymentString();
    }

    public Collection<ImportedBundle> getRequiredBundles() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getRequiredBundles");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getRequiredBundles", this._requiredBundles);
        return Collections.unmodifiableCollection(this._requiredBundles);
    }

    public ImportedBundle getFragmentHost() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getFragmentHost");
        ImportedBundle result = this._exportedBundle.getFragmentHost();
        this.logger.debug("Method exit: {}, returning {}", (Object)"getFragmentHost", (Object)result);
        return result;
    }

    public boolean isFragment() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isFragment");
        boolean result = this._exportedBundle.isFragment();
        this.logger.debug("Method exit: {}, returning {}", (Object)"isFragment", (Object)result);
        return result;
    }
}

