/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.filesystem.IDirectory;
import org.apache.aries.application.filesystem.IFile;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.application.modelling.ModellerException;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.modelling.ParsedServiceElements;
import org.apache.aries.application.modelling.ParserProxy;
import org.apache.aries.application.modelling.internal.BundleBlueprintParser;
import org.apache.aries.application.utils.manifest.BundleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelledResourceManagerImpl
implements ModelledResourceManager {
    private Logger _logger = LoggerFactory.getLogger(ModelledResourceManagerImpl.class);
    private ParserProxy _parserProxy;
    private ModellingManager _modellingManager;

    public void setModellingManager(ModellingManager m) {
        this._modellingManager = m;
    }

    public void setParserProxy(ParserProxy p) {
        this._parserProxy = p;
    }

    public ParserProxy getParserProxy() {
        return this._parserProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedServiceElements getServiceElements(IDirectory archive) throws ModellerException {
        this._logger.debug("Method entry: {}, args {}", (Object)"getServiceElements", (Object)archive);
        HashSet services = new HashSet();
        HashSet references = new HashSet();
        try {
            Collection<IFile> blueprints = this.findBlueprints(archive);
            InputStream is = null;
            for (IFile bpFile : blueprints) {
                URL url = bpFile.toURL();
                URLConnection conn = url.openConnection();
                is = conn.getInputStream();
                try {
                    ParsedServiceElements pse = this.getParserProxy().parseAllServiceElements(is);
                    services.addAll(pse.getServices());
                    references.addAll(pse.getReferences());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (URISyntaxException e) {
            ModellerException m = new ModellerException((Exception)e);
            this._logger.debug("Method exit: {}, returning {}", (Object)"getServiceElements", (Object)m);
            throw m;
        }
        catch (IOException e) {
            ModellerException m = new ModellerException((Exception)e);
            this._logger.debug("Method exit: {}, returning {}", (Object)"getServiceElements", (Object)m);
            throw m;
        }
        catch (Exception e) {
            ModellerException m = new ModellerException(e);
            this._logger.debug("Method exit: {}, returning {}", (Object)"getServiceElements", (Object)m);
            throw m;
        }
        ParsedServiceElements result = this._modellingManager.getParsedServiceElements(services, references);
        this._logger.debug("Method exit: {}, returning {}", (Object)"getServiceElements", (Object)result);
        return result;
    }

    public ModelledResource getModelledResource(String uri, IDirectory bundle) throws ModellerException {
        ModelledResource mbi;
        this._logger.debug("Method entry: {}, args {}", (Object)"getModelledResource", (Object)new Object[]{uri, bundle});
        ParsedServiceElements pse = this.getServiceElements(bundle);
        BundleManifest bm = BundleManifest.fromBundle((File)new File(bundle.toString()));
        Attributes attributes = bm.getRawAttributes();
        try {
            mbi = this._modellingManager.getModelledResource(uri, attributes, pse.getReferences(), pse.getServices());
        }
        catch (InvalidAttributeException iae) {
            throw new ModellerException((Exception)((Object)iae));
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"getModelledResource", (Object)mbi);
        return mbi;
    }

    private Collection<IFile> findBlueprints(IDirectory oneBundle) throws IOException, URISyntaxException {
        this._logger.debug("Method entry: {}, args {}", (Object)"findBlueprints", (Object)oneBundle);
        HashSet<IDirectory> archiveSet = new HashSet<IDirectory>();
        archiveSet.add(oneBundle);
        Collection<IFile> result = this.findBlueprints(archiveSet);
        this._logger.debug("Method exit: {}, returning {}", (Object)"findBlueprints", result);
        return result;
    }

    private Collection<IFile> findBlueprints(Collection<IDirectory> applicationBundles) throws IOException, URISyntaxException {
        this._logger.debug("Method entry: {}, args {}", (Object)"findBlueprints", applicationBundles);
        ArrayList<IFile> blueprints = new ArrayList<IFile>();
        for (IDirectory appBundle : applicationBundles) {
            if (appBundle == null) continue;
            BundleManifest bundleMf = BundleManifest.fromBundle((IFile)appBundle);
            BundleBlueprintParser bpParser = new BundleBlueprintParser(bundleMf);
            List files = appBundle.listAllFiles();
            for (IFile file : files) {
                String directoryFullPath = file.getName();
                String directoryName = "";
                String fileName = "";
                if (directoryFullPath.lastIndexOf("/") != -1) {
                    directoryName = directoryFullPath.substring(0, directoryFullPath.lastIndexOf("/"));
                    fileName = directoryFullPath.substring(directoryFullPath.lastIndexOf("/") + 1);
                } else if (file.isFile()) {
                    directoryName = "";
                    fileName = directoryFullPath;
                }
                if (!bpParser.isBPFile(directoryName, fileName)) continue;
                blueprints.add(file);
            }
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"findBlueprints", blueprints);
        return blueprints;
    }
}

