/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.modelling.ParsedServiceElements;
import org.apache.aries.application.modelling.ParserProxy;
import org.apache.aries.application.modelling.WrappedServiceMetadata;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ParserService;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserProxyImpl
implements ParserProxy {
    private Logger _logger = LoggerFactory.getLogger(ParserProxyImpl.class);
    private ParserService _parserService;
    private BundleContext _bundleContext;
    private ModellingManager _modellingManager;

    public void setParserService(ParserService p) {
        this._parserService = p;
    }

    public void setBundleContext(BundleContext b) {
        this._bundleContext = b;
    }

    public void setModellingManager(ModellingManager m) {
        this._modellingManager = m;
    }

    public List<? extends WrappedServiceMetadata> parse(List<URL> blueprintsToParse) throws Exception {
        this._logger.debug("Method entry: {}, args {}", (Object)"parse", (Object)new Object[]{blueprintsToParse});
        ComponentDefinitionRegistry cdr = this._parserService.parse(blueprintsToParse, this._bundleContext.getBundle());
        List<ExportedService> result = this.parseCDRForServices(cdr, true);
        this._logger.debug("Method exit: {}, returning {}", (Object)"parse", (Object)new Object[]{result});
        return result;
    }

    public List<? extends WrappedServiceMetadata> parse(URL blueprintToParse) throws Exception {
        this._logger.debug("Method entry: {}, args {}", (Object)"parse", (Object)new Object[]{blueprintToParse});
        ArrayList<URL> list = new ArrayList<URL>();
        list.add(blueprintToParse);
        List<? extends WrappedServiceMetadata> result = this.parse(list);
        this._logger.debug("Method exit: {}, returning {}", (Object)"parse", (Object)new Object[]{result});
        return result;
    }

    public List<? extends WrappedServiceMetadata> parse(InputStream blueprintToParse) throws Exception {
        this._logger.debug("Method entry: {}, args {}", (Object)"parse", (Object)new Object[]{blueprintToParse});
        ComponentDefinitionRegistry cdr = this._parserService.parse(blueprintToParse, this._bundleContext.getBundle());
        List<ExportedService> result = this.parseCDRForServices(cdr, true);
        this._logger.debug("Method exit: {}, returning {}", (Object)"parse", (Object)new Object[]{result});
        return result;
    }

    public ParsedServiceElements parseAllServiceElements(InputStream blueprintToParse) throws Exception {
        this._logger.debug("Method entry: {}, args {}", (Object)"parseAllServiceElements", (Object)new Object[]{blueprintToParse});
        ComponentDefinitionRegistry cdr = this._parserService.parse(blueprintToParse, this._bundleContext.getBundle());
        List<ExportedService> services = this.parseCDRForServices(cdr, false);
        List<ImportedService> references = this.parseCDRForReferences(cdr);
        ParsedServiceElements result = this._modellingManager.getParsedServiceElements(services, references);
        this._logger.debug("Method exit: {}, returning {}", (Object)"parseAllServiceElements", (Object)new Object[]{result});
        return result;
    }

    private List<ExportedService> parseCDRForServices(ComponentDefinitionRegistry cdr, boolean suppressAnonymousServices) {
        this._logger.debug("Method entry: {}, args {}", (Object)"parseCDRForServices", (Object)new Object[]{cdr, suppressAnonymousServices});
        ArrayList<ExportedService> result = new ArrayList<ExportedService>();
        Set names = cdr.getComponentDefinitionNames();
        for (String name : names) {
            ComponentMetadata compMetadata = cdr.getComponentDefinition(name);
            if (!(compMetadata instanceof ServiceMetadata)) continue;
            ServiceMetadata serviceMetadata = (ServiceMetadata)compMetadata;
            ArrayList<String> interfaces = new ArrayList<String>();
            HashMap<String, Object> serviceProps = new HashMap<String, Object>();
            int ranking = serviceMetadata.getRanking();
            for (Object i : serviceMetadata.getInterfaces()) {
                interfaces.add((String)i);
            }
            List props = serviceMetadata.getServiceProperties();
            for (MapEntry entry : props) {
                String key = ((ValueMetadata)entry.getKey()).getStringValue();
                Metadata value = entry.getValue();
                if (value instanceof CollectionMetadata) {
                    List values = ((CollectionMetadata)value).getValues();
                    String[] theseValues = new String[values.size()];
                    for (int i = 0; i < values.size(); ++i) {
                        Metadata m = (Metadata)values.get(i);
                        theseValues[i] = ((ValueMetadata)m).getStringValue();
                    }
                    serviceProps.put(key, theseValues);
                    continue;
                }
                serviceProps.put(key, ((ValueMetadata)entry.getValue()).getStringValue());
            }
            String serviceName = serviceMetadata.getId();
            Target t = serviceMetadata.getServiceComponent();
            String targetId = null;
            if (t instanceof RefMetadata) {
                targetId = ((RefMetadata)t).getComponentId();
            } else if (t instanceof BeanMetadata) {
                targetId = ((BeanMetadata)t).getId();
            }
            if (targetId != null && !targetId.startsWith(".")) {
                serviceProps.put("osgi.service.blueprint.compname", targetId);
                if (serviceName == null || serviceName.equals("") || serviceName.startsWith(".")) {
                    serviceName = targetId;
                }
            }
            if (serviceName != null && serviceName.startsWith(".")) {
                serviceName = null;
            }
            if (suppressAnonymousServices && serviceName == null) continue;
            ExportedService wsm = this._modellingManager.getExportedService(serviceName, ranking, interfaces, serviceProps);
            result.add(wsm);
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"parseAllServiceElements", (Object)new Object[]{result});
        return result;
    }

    private List<ImportedService> parseCDRForReferences(ComponentDefinitionRegistry cdr) throws InvalidAttributeException {
        this._logger.debug("Method entry: {}, args {}", (Object)"parseCDRForReferences", (Object)new Object[]{cdr});
        ArrayList<ImportedService> result = new ArrayList<ImportedService>();
        Set names = cdr.getComponentDefinitionNames();
        for (String name : names) {
            ComponentMetadata compMetadata = cdr.getComponentDefinition(name);
            if (!(compMetadata instanceof ServiceReferenceMetadata)) continue;
            ServiceReferenceMetadata referenceMetadata = (ServiceReferenceMetadata)compMetadata;
            boolean optional = referenceMetadata.getAvailability() == 2;
            String iface = referenceMetadata.getInterface();
            String compName = referenceMetadata.getComponentName();
            String blueprintFilter = referenceMetadata.getFilter();
            String id = referenceMetadata.getId();
            boolean isMultiple = referenceMetadata instanceof ReferenceListMetadata;
            if (!this.isNotBlacklisted(iface, blueprintFilter)) continue;
            ImportedService ref = this._modellingManager.getImportedService(optional, iface, compName, blueprintFilter, id, isMultiple);
            result.add(ref);
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"parseCDRForReferences", (Object)new Object[]{result});
        return result;
    }

    private boolean isNotBlacklisted(String iface, String blueprintFilter) {
        this._logger.debug("Method entry: {}, args {}", (Object)"isNotBlacklisted", (Object)new Object[]{iface, blueprintFilter});
        boolean blacklisted = false;
        if (iface != null) {
            blacklisted |= iface.equals("javax.persistence.EntityManagerFactory");
            blacklisted |= iface.equals("javax.persistence.EntityManager");
            blacklisted |= iface.equals("javax.transaction.UserTransaction");
            blacklisted |= iface.equals("javax.transaction.TransactionSynchronizationRegistry");
            if (blueprintFilter != null && !blueprintFilter.trim().isEmpty()) {
                Map filter = ManifestHeaderProcessor.parseFilter((String)blueprintFilter);
                blacklisted |= filter.containsKey("osgi.jndi.service.name");
            }
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"isNotBlacklisted", (Object)new Object[]{!blacklisted});
        return !blacklisted;
    }
}

