/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.aries.application.utils.manifest.BundleManifest;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;

public class BundleBlueprintParser {
    public static final String DEFAULT_HEADER = "OSGI-INF/blueprint/*.xml";
    String _mfHeader = null;
    List<Path> _paths;

    public BundleBlueprintParser(BundleManifest bundleMf) {
        String bundleBPHeader = bundleMf.getRawAttributes().getValue("Bundle-Blueprint");
        this.setup(bundleBPHeader);
    }

    public BundleBlueprintParser(String bundleBPHeader) {
        this.setup(bundleBPHeader);
    }

    public BundleBlueprintParser() {
        this.setup(null);
    }

    private void setup(String bundleBPHeader) {
        this._paths = new LinkedList<Path>();
        this._mfHeader = bundleBPHeader == null ? DEFAULT_HEADER : bundleBPHeader;
        List files = ManifestHeaderProcessor.split((String)this._mfHeader, (String)",");
        for (String fileClause : files) {
            String f;
            List yetMoreFiles = ManifestHeaderProcessor.split((String)fileClause, (String)";");
            Iterator i$ = yetMoreFiles.iterator();
            while (i$.hasNext() && !(f = (String)i$.next()).contains("=")) {
                if ((f = f.trim()).startsWith("\"") && f.endsWith("\"")) {
                    f = f.substring(1, f.length() - 1);
                }
                int index = f.lastIndexOf(47);
                String path = "";
                String file = f;
                if (index != -1) {
                    path = f.substring(0, index);
                    file = f.substring(index + 1);
                }
                this._paths.add(new Path(path, file));
            }
        }
    }

    public boolean isBPFile(String directory, String filename) {
        for (Path path : this._paths) {
            if (!path.matches(directory, filename)) continue;
            return true;
        }
        return false;
    }

    static class Path {
        String directory;
        String filename;
        Pattern filenamePattern;

        public Path(String d, String f) {
            this.directory = d;
            if (f.contains("*")) {
                this.filename = null;
                String pattern = f.replace(".", "\\.");
                pattern = pattern.replace("*", ".*");
                this.filenamePattern = Pattern.compile(pattern);
            } else {
                this.filename = f;
                this.filenamePattern = null;
            }
        }

        public boolean matches(String dir, String fil) {
            boolean match = false;
            match = !this.directory.equals(dir) ? false : (this.filename != null ? this.filename.equals(fil) : this.filenamePattern.matcher(fil).matches());
            return match;
        }
    }
}

