/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.utils.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.VersionRange;
import org.apache.aries.application.modelling.DeployedBundles;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.modelling.ImportedPackage;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.Provider;
import org.apache.aries.application.modelling.impl.DeployedBundlesImpl;
import org.apache.aries.application.modelling.impl.ImportedBundleImpl;
import org.apache.aries.application.modelling.impl.ImportedPackageImpl;
import org.apache.aries.application.modelling.internal.MessageUtil;
import org.apache.aries.application.modelling.utils.ModellingHelper;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModellingHelperImpl
implements ModellingHelper {
    private static final Logger logger = LoggerFactory.getLogger(ModellingHelperImpl.class);

    public boolean areMandatoryAttributesPresent(Map<String, String> consumerAttributes, Provider p) {
        return ModellingHelperImpl.areMandatoryAttributesPresent_(consumerAttributes, p);
    }

    public ImportedBundle buildFragmentHost(String fragmentHostHeader) throws InvalidAttributeException {
        return ModellingHelperImpl.buildFragmentHost_(fragmentHostHeader);
    }

    public ImportedPackage intersectPackage(ImportedPackage p1, ImportedPackage p2) {
        return ModellingHelperImpl.intersectPackage_(p1, p2);
    }

    public DeployedBundles createDeployedBundles(String assetName, Collection<ImportedBundle> appContentNames, Collection<ImportedBundle> appUseBundleNames, Collection<ModelledResource> fakeServiceProvidingBundles) {
        logger.debug("Method entry: {}, args {}", (Object)"createDeployedBundles", (Object)new Object[]{assetName, appContentNames, appUseBundleNames, fakeServiceProvidingBundles});
        DeployedBundlesImpl result = new DeployedBundlesImpl(assetName, appContentNames, appUseBundleNames, fakeServiceProvidingBundles);
        logger.debug("Method exit: {}, returning {}", (Object)"createDeployedBundles", (Object)result);
        return result;
    }

    public static boolean areMandatoryAttributesPresent_(Map<String, String> consumerAttributes, Provider p) {
        logger.debug("Method entry: {}, args {}", (Object)"areMandatoryAttributesPresent_", (Object)new Object[]{consumerAttributes, p});
        boolean allPresent = true;
        String mandatory = (String)p.getAttributes().get("mandatory:");
        if (mandatory != null && !mandatory.equals("")) {
            String name;
            List attributeNames = ManifestHeaderProcessor.split((String)mandatory, (String)",");
            Iterator i$ = attributeNames.iterator();
            while (i$.hasNext() && (allPresent = consumerAttributes.containsKey(name = (String)i$.next()))) {
            }
        }
        logger.debug("Method exit: {}, returning {}", (Object)"areMandatoryAttributesPresent_", (Object)allPresent);
        return allPresent;
    }

    public static ImportedBundle buildFragmentHost_(String fragmentHostHeader) throws InvalidAttributeException {
        logger.debug("Method entry: {}, args {}", (Object)"buildFragmentHost_", (Object)new Object[]{fragmentHostHeader});
        if (fragmentHostHeader == null) {
            return null;
        }
        Map parsedFragHost = ManifestHeaderProcessor.parseImportString((String)fragmentHostHeader);
        if (parsedFragHost.size() != 1) {
            throw new InvalidAttributeException(MessageUtil.getMessage("APPUTILS0001W", new Object[]{fragmentHostHeader}, "An internal error occurred. A bundle fragment manifest must define exactly one Fragment-Host entry. The following entry was found" + fragmentHostHeader + "."));
        }
        String hostName = (String)parsedFragHost.keySet().iterator().next();
        Map attribs = (Map)parsedFragHost.get(hostName);
        String bundleVersion = (String)attribs.remove("bundle-version");
        if (bundleVersion != null && attribs.get("version") == null) {
            attribs.put("version", bundleVersion);
        }
        attribs.put("symbolicname", hostName);
        String filter = ManifestHeaderProcessor.generateFilter((Map)attribs);
        ImportedBundleImpl result = new ImportedBundleImpl(filter, attribs);
        logger.debug("Method exit: {}, returning {}", (Object)"buildFragmentHost_", (Object)result);
        return result;
    }

    public static ImportedPackage intersectPackage_(ImportedPackage p1, ImportedPackage p2) {
        logger.debug("Method entry: {}, args {}", (Object)"intersectPackage_", (Object)new Object[]{p1, p2});
        ImportedPackageImpl result = null;
        if (p1.getPackageName().equals(p2.getPackageName())) {
            HashMap<String, String> mergedAttribs;
            HashMap<String, String> att1 = new HashMap<String, String>(p1.getAttributes());
            HashMap att2 = new HashMap(p2.getAttributes());
            String rangeStr1 = (String)att1.remove("version");
            String rangeStr2 = (String)att2.remove("version");
            att1.remove("resolution:");
            att2.remove("resolution:");
            HashMap<String, String> hashMap = mergedAttribs = ((Object)att1).equals(att2) ? att1 : null;
            if (mergedAttribs == null) {
                result = null;
            } else {
                boolean isIntersectSuccessful = true;
                if (rangeStr1 != null && rangeStr2 != null) {
                    VersionRange range2;
                    VersionRange range1 = ManifestHeaderProcessor.parseVersionRange((String)rangeStr1);
                    VersionRange intersectRange = range1.intersect(range2 = ManifestHeaderProcessor.parseVersionRange((String)rangeStr2));
                    if (intersectRange == null) {
                        isIntersectSuccessful = false;
                    } else {
                        mergedAttribs.put("version", intersectRange.toString());
                    }
                } else if (rangeStr1 != null) {
                    mergedAttribs.put("version", rangeStr1);
                } else if (rangeStr2 != null) {
                    mergedAttribs.put("version", rangeStr2);
                }
                if (p1.isOptional() && p2.isOptional()) {
                    mergedAttribs.put("resolution:", "optional");
                }
                try {
                    result = isIntersectSuccessful ? new ImportedPackageImpl(p1.getPackageName(), mergedAttribs) : null;
                }
                catch (InvalidAttributeException iax) {
                    logger.error(iax.getMessage());
                }
            }
        }
        logger.debug("Method exit: {}, returning {}", (Object)"intersectPackage_", result);
        return result;
    }
}

