/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.util.Assertions;

public abstract class BaseBlobStore
implements BlobStore {
    protected final BlobStoreContext context;
    protected final BlobUtils blobUtils;
    protected final Supplier<Location> defaultLocation;
    protected final Supplier<Set<? extends Location>> locations;

    @Inject
    protected BaseBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations) {
        this.context = (BlobStoreContext)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.blobUtils = (BlobUtils)Preconditions.checkNotNull((Object)blobUtils, (Object)"blobUtils");
        this.defaultLocation = (Supplier)Preconditions.checkNotNull(defaultLocation, (Object)"defaultLocation");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
    }

    @Override
    public BlobStoreContext getContext() {
        return this.context;
    }

    @Override
    public BlobBuilder blobBuilder(String name) {
        return this.blobUtils.blobBuilder().name(name);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container) {
        return this.list(container, ListContainerOptions.NONE);
    }

    @Override
    public boolean directoryExists(String containerName, String directory) {
        return this.blobUtils.directoryExists(containerName, directory);
    }

    @Override
    public void createDirectory(String containerName, String directory) {
        this.blobUtils.createDirectory(containerName, directory);
    }

    @Override
    public long countBlobs(String container) {
        return this.countBlobs(container, ListContainerOptions.Builder.recursive());
    }

    @Override
    public long countBlobs(String containerName, ListContainerOptions options) {
        return this.blobUtils.countBlobs(containerName, options);
    }

    @Override
    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void clearContainer(String containerName, ListContainerOptions options) {
        this.blobUtils.clearContainer(containerName, options);
    }

    @Override
    public void deleteDirectory(String containerName, String directory) {
        this.blobUtils.deleteDirectory(containerName, directory);
    }

    @Override
    public Blob getBlob(String container, String key) {
        return this.getBlob(container, key, GetOptions.NONE);
    }

    @Override
    public void deleteContainer(String container) {
        this.clearAndDeleteContainer(container);
    }

    protected void clearAndDeleteContainer(final String container) {
        try {
            if (!Assertions.eventuallyTrue((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        BaseBlobStore.this.clearContainer(container, ListContainerOptions.Builder.recursive());
                        return BaseBlobStore.this.deleteAndVerifyContainerGone(container);
                    }
                    catch (ContainerNotFoundException e) {
                        return true;
                    }
                }
            }, (long)30000L)) {
                throw new IllegalStateException(container + " still exists after deleting!");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(container + " interrupted during deletion!", e);
        }
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return (Set)this.locations.get();
    }

    protected abstract boolean deleteAndVerifyContainerGone(String var1);
}

