/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.mortbay.log.Log;
import org.mortbay.util.IntrospectionUtil;

public class Injection {
    private Class _targetClass;
    private String _jndiName;
    private String _mappingName;
    private Member _target;

    public Class getTargetClass() {
        return this._targetClass;
    }

    public void setTargetClass(Class clazz) {
        this._targetClass = clazz;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
    }

    public String getMappingName() {
        return this._mappingName;
    }

    public void setMappingName(String mappingName) {
        this._mappingName = mappingName;
    }

    public Member getTarget() {
        return this._target;
    }

    public void setTarget(Member target) {
        this._target = target;
    }

    public void setTarget(Class clazz, String targetName, Class targetType) {
        String setter = "set" + targetName.substring(0, 1).toUpperCase() + targetName.substring(1);
        try {
            Log.debug("Looking for method for setter: " + setter + " with arg " + targetType);
            this._target = IntrospectionUtil.findMethod(clazz, setter, new Class[]{targetType}, true, false);
            this._targetClass = clazz;
        }
        catch (NoSuchMethodException me) {
            try {
                this._target = IntrospectionUtil.findField(clazz, targetName, targetType, true, false);
                this._targetClass = clazz;
            }
            catch (NoSuchFieldException fe) {
                throw new IllegalArgumentException("No such field or method " + targetName + " on class " + this._targetClass);
            }
        }
    }

    public void inject(Object injectable) {
        Member theTarget = this.getTarget();
        if (theTarget instanceof Field) {
            this.injectField((Field)theTarget, injectable);
        } else if (theTarget instanceof Method) {
            this.injectMethod((Method)theTarget, injectable);
        }
    }

    public Object lookupInjectedValue() throws NamingException {
        InitialContext context = new InitialContext();
        return context.lookup("java:comp/env/" + this.getJndiName());
    }

    public void injectField(Field field, Object injectable) {
        try {
            boolean accessibility = field.isAccessible();
            field.setAccessible(true);
            field.set(injectable, this.lookupInjectedValue());
            field.setAccessible(accessibility);
        }
        catch (Exception e) {
            Log.warn(e);
            throw new IllegalStateException("Inject failed for field " + field.getName());
        }
    }

    public void injectMethod(Method method, Object injectable) {
        try {
            boolean accessibility = method.isAccessible();
            method.setAccessible(true);
            method.invoke(injectable, this.lookupInjectedValue());
            method.setAccessible(accessibility);
        }
        catch (Exception e) {
            Log.warn(e);
            throw new IllegalStateException("Inject failed for method " + method.getName());
        }
    }

    private void validateInjection(Method method, Object injectable) throws NoSuchMethodException {
        if (injectable == null || method == null) {
            return;
        }
        injectable.getClass().getMethod(method.getName(), method.getParameterTypes());
    }

    private void validateInjection(Field field, Object injectable) throws NoSuchFieldException {
        if (field == null || injectable == null) {
            return;
        }
        Field f = injectable.getClass().getField(field.getName());
        if (!f.getType().isAssignableFrom(field.getType())) {
            throw new NoSuchFieldException("Mismatching type of field: " + f.getType().getName() + " v " + field.getType().getName());
        }
    }
}

