/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.jetty.plus.naming.NamingEntryUtil;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public class Transaction
extends NamingEntry {
    public static final String USER_TRANSACTION = "UserTransaction";

    public static void bindToENC() throws NamingException {
        Transaction txEntry = (Transaction)NamingEntryUtil.lookupNamingEntry(null, USER_TRANSACTION);
        if (txEntry == null) {
            throw new NameNotFoundException("UserTransaction not found");
        }
        txEntry.bindToComp();
    }

    public Transaction(UserTransaction userTransaction) throws NamingException {
        super(USER_TRANSACTION, userTransaction);
    }

    public void bindToENC(String localName) throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp/env");
        Log.debug("Binding java:comp/env" + this.getJndiName() + " to " + this.objectNameString);
        NamingUtil.bind(env, localName, new LinkRef(this.objectNameString));
    }

    private void bindToComp() throws NamingException {
        InitialContext ic = new InitialContext();
        Context env = (Context)ic.lookup("java:comp");
        Log.debug("Binding java:comp/" + this.getJndiName() + " to " + this.objectNameString);
        NamingUtil.bind(env, this.getJndiName(), new LinkRef(this.objectNameString));
    }

    public void unbindENC() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp");
            Log.debug("Unbinding java:comp/" + this.getJndiName());
            env.unbind(this.getJndiName());
        }
        catch (NamingException e) {
            Log.warn(e);
        }
    }
}

