/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.naming;

import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingContext;

public class ContextFactory
implements ObjectFactory {
    private static WeakHashMap _contextMap = new WeakHashMap();
    private static ThreadLocal _threadContext = new ThreadLocal();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Context ctx = (Context)_threadContext.get();
        if (ctx != null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Using the Context that is bound on the thread");
            }
            return ctx;
        }
        ClassLoader loader = null;
        if (ContextHandler.getCurrentContext() != null) {
            loader = ContextHandler.getCurrentContext().getContextHandler().getClassLoader();
        }
        if (loader != null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Using classloader of current org.mortbay.jetty.handler.ContextHandler");
            }
        } else {
            loader = Thread.currentThread().getContextClassLoader();
            if (Log.isDebugEnabled()) {
                Log.debug("Using thread context classloader");
            }
        }
        if ((ctx = (Context)_contextMap.get(loader)) == null && (ctx = this.getParentClassLoaderContext(loader)) == null) {
            Reference ref = (Reference)obj;
            StringRefAddr parserAddr = (StringRefAddr)ref.get("parser");
            String parserClassName = parserAddr == null ? null : (String)parserAddr.getContent();
            NameParser parser = parserClassName == null ? null : loader.loadClass(parserClassName).newInstance();
            ctx = new NamingContext(env, name.get(0), nameCtx, parser);
            if (Log.isDebugEnabled()) {
                Log.debug("No entry for classloader: " + loader);
            }
            _contextMap.put(loader, ctx);
        }
        return ctx;
    }

    public Context getParentClassLoaderContext(ClassLoader loader) {
        Context ctx = null;
        ClassLoader cl = loader;
        for (cl = cl.getParent(); cl != null && ctx == null; cl = cl.getParent()) {
            ctx = (Context)_contextMap.get(cl);
        }
        return ctx;
    }

    public static Context setComponentContext(Context ctx) {
        Context previous = (Context)_threadContext.get();
        _threadContext.set(ctx);
        return previous;
    }

    public static void resetComponentContext(Context ctx) {
        _threadContext.set(ctx);
    }
}

