/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.resolver.obr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.Content;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.VersionRange;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ResolveConstraint;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.management.spi.repository.PlatformRepository;
import org.apache.aries.application.management.spi.resolve.AriesApplicationResolver;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.modelling.utils.ModellingHelper;
import org.apache.aries.application.resolver.internal.MessageUtil;
import org.apache.aries.application.resolver.obr.impl.ApplicationResourceImpl;
import org.apache.aries.application.resolver.obr.impl.ModelledBundleResource;
import org.apache.aries.application.resolver.obr.impl.OBRBundleInfo;
import org.apache.aries.application.resolver.obr.impl.RepositoryGeneratorImpl;
import org.apache.aries.application.resolver.obr.impl.ResourceWrapper;
import org.apache.aries.application.utils.filesystem.IOUtils;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBRAriesResolver
implements AriesApplicationResolver {
    private static Logger log = LoggerFactory.getLogger(OBRAriesResolver.class);
    private final RepositoryAdmin repositoryAdmin;
    private boolean returnOptionalResources = true;
    private PlatformRepository platformRepository;
    private ModellingManager modellingManager;
    private ModellingHelper modellingHelper;
    private static final Set<String> SPECIAL_FILTER_ATTRS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("package", "symbolicname", "service", "version")));

    public void setModellingManager(ModellingManager m) {
        this.modellingManager = m;
    }

    public void setModellingHelper(ModellingHelper mh) {
        this.modellingHelper = mh;
    }

    public PlatformRepository getPlatformRepository() {
        return this.platformRepository;
    }

    public RepositoryAdmin getRepositoryAdmin() {
        return this.repositoryAdmin;
    }

    public void setPlatformRepository(PlatformRepository platformRepository) {
        this.platformRepository = platformRepository;
    }

    public OBRAriesResolver(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public void setReturnOptionalResources(boolean optional) {
        this.returnOptionalResources = optional;
    }

    public boolean getReturnOptionalResources() {
        return this.returnOptionalResources;
    }

    public Collection<ModelledResource> resolve(String appName, String appVersion, Collection<ModelledResource> byValueBundles, Collection<Content> inputs) throws ResolverException {
        return this.resolve(appName, appVersion, byValueBundles, inputs, this.platformRepository);
    }

    public Collection<ModelledResource> resolve(String appName, String appVersion, Collection<ModelledResource> byValueBundles, Collection<Content> inputs, PlatformRepository platformRepository) throws ResolverException {
        log.debug("Method entry: {}, args {}", (Object)"resolve", (Object)new Object[]{appName, appVersion, byValueBundles, inputs});
        Collection<ImportedBundle> importedBundles = this.toImportedBundle(inputs);
        ArrayList<ModelledResource> toReturn = new ArrayList<ModelledResource>();
        Resolver obrResolver = this.getConfiguredObrResolver(appName, appVersion, byValueBundles, platformRepository);
        obrResolver.add(this.createApplicationResource(appName, appVersion, importedBundles));
        if (obrResolver.resolve()) {
            List<Resource> requiredResources = this.retrieveRequiredResources(obrResolver);
            if (requiredResources == null) {
                log.debug("resolver.getRequiredResources() returned null");
            } else {
                for (Resource r : requiredResources) {
                    ManifestHeaderProcessor.NameValueMap attribs = new ManifestHeaderProcessor.NameValueMap();
                    attribs.put((Object)"version", (Object)("[" + r.getVersion() + ',' + r.getVersion() + "]"));
                    ModelledBundleResource modelledResourceForThisMatch = null;
                    if (r.getSymbolicName() == null) continue;
                    try {
                        modelledResourceForThisMatch = new ModelledBundleResource(r, this.modellingManager, this.modellingHelper);
                    }
                    catch (InvalidAttributeException iax) {
                        ResolverException re = new ResolverException("Internal error occurred: " + iax.toString());
                        log.debug("Method exit: {}, returning {}", (Object)"resolve", (Object)re);
                        throw re;
                    }
                    toReturn.add(modelledResourceForThisMatch);
                }
            }
            log.debug("Method exit: {}, returning {}", (Object)"resolve", toReturn);
            return toReturn;
        }
        Reason[] reasons = obrResolver.getUnsatisfiedRequirements();
        Map<String, Set<String>> refinedReqs = this.refineUnsatisfiedRequirements(obrResolver, reasons);
        StringBuffer reqList = new StringBuffer();
        LinkedList<String> unsatisfiedRequirements = new LinkedList<String>();
        for (Map.Entry<String, Set<String>> filterEntry : refinedReqs.entrySet()) {
            log.debug("unable to satisfy the filter , filter = " + filterEntry.getKey() + "required by " + filterEntry.getValue());
            String reason = this.extractConsumableMessageInfo(filterEntry.getKey(), filterEntry.getValue());
            reqList.append('\n');
            reqList.append(reason);
            unsatisfiedRequirements.add(reason);
        }
        ResolverException re = new ResolverException(MessageUtil.getMessage("RESOLVER_UNABLE_TO_RESOLVE", appName, reqList));
        re.setUnsatisfiedRequirements(unsatisfiedRequirements);
        log.debug("Method exit: {}, returning {}", (Object)"resolve", (Object)re);
        throw re;
    }

    private Resolver getConfiguredObrResolver(String appName, String appVersion, Collection<ModelledResource> byValueBundles) throws ResolverException {
        return this.getConfiguredObrResolver(appName, appVersion, byValueBundles, this.platformRepository);
    }

    private Resolver getConfiguredObrResolver(String appName, String appVersion, Collection<ModelledResource> byValueBundles, PlatformRepository platformRepository) throws ResolverException {
        Repository[] repos;
        Repository appRepo;
        log.debug("Method entry: {}, args {}", (Object)"getConfiguredObrResolver", (Object)new Object[]{appName, appVersion, byValueBundles});
        DataModelHelper helper = this.repositoryAdmin.getHelper();
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            RepositoryGeneratorImpl.generateRepository(this.repositoryAdmin, appName + "_" + appVersion, byValueBundles, bytesOut);
            appRepo = helper.readRepository((Reader)new InputStreamReader(new ByteArrayInputStream(bytesOut.toByteArray())));
        }
        catch (Exception e) {
            throw new ResolverException(e);
        }
        ArrayList<Repository> resolveRepos = new ArrayList<Repository>();
        resolveRepos.add(this.repositoryAdmin.getSystemRepository());
        if (!this.excludeLocalRuntime()) {
            resolveRepos.add(this.getLocalRepository(this.repositoryAdmin));
        }
        resolveRepos.add(appRepo);
        for (Repository r : repos = this.repositoryAdmin.listRepositories()) {
            resolveRepos.add(r);
        }
        Resolver obrResolver = this.repositoryAdmin.resolver(resolveRepos.toArray(new Repository[resolveRepos.size()]));
        this.addPlatformRepositories(obrResolver, appName, platformRepository);
        log.debug("Method exit: {}, returning {}", (Object)"getConfiguredObrResolver", (Object)obrResolver);
        return obrResolver;
    }

    @Deprecated
    public Set<BundleInfo> resolve(AriesApplication app, ResolveConstraint ... constraints) throws ResolverException {
        log.trace("resolving {}", (Object)app);
        ApplicationMetadata appMeta = app.getApplicationMetadata();
        String appName = appMeta.getApplicationSymbolicName();
        Version appVersion = appMeta.getApplicationVersion();
        List appContent = appMeta.getApplicationContents();
        Collection useBundleContent = appMeta.getUseBundles();
        ArrayList<Content> contents = new ArrayList<Content>();
        contents.addAll(appContent);
        contents.addAll(useBundleContent);
        if (constraints != null && constraints.length > 0) {
            for (ResolveConstraint con : constraints) {
                contents.add(ManifestHeaderProcessor.parseContent((String)con.getBundleName(), (String)con.getVersionRange().toString()));
            }
        }
        Resolver obrResolver = this.getConfiguredObrResolver(appName, appVersion.toString(), this.toModelledResource(app.getBundleInfo()));
        obrResolver.add(this.createApplicationResource(appName, appVersion, contents));
        if (obrResolver.resolve()) {
            HashSet<BundleInfo> result = new HashSet<BundleInfo>();
            List<Resource> requiredResources = this.retrieveRequiredResources(obrResolver);
            for (Resource resource : requiredResources) {
                BundleInfo bundleInfo = this.toBundleInfo(resource, false);
                result.add(bundleInfo);
            }
            if (this.returnOptionalResources) {
                for (Resource resource : obrResolver.getOptionalResources()) {
                    BundleInfo bundleInfo = this.toBundleInfo(resource, true);
                    result.add(bundleInfo);
                }
            }
            return result;
        }
        Reason[] reasons = obrResolver.getUnsatisfiedRequirements();
        Map<String, Set<String>> refinedReqs = this.refineUnsatisfiedRequirements(obrResolver, reasons);
        StringBuffer reqList = new StringBuffer();
        LinkedList<String> unsatisfiedRequirements = new LinkedList<String>();
        for (Map.Entry<String, Set<String>> filterEntry : refinedReqs.entrySet()) {
            log.debug("unable to satisfied the filter , filter = " + filterEntry.getKey() + "required by " + filterEntry.getValue());
            String reason = this.extractConsumableMessageInfo(filterEntry.getKey(), filterEntry.getValue());
            reqList.append('\n');
            reqList.append(reason);
            unsatisfiedRequirements.add(reason);
        }
        ResolverException re = new ResolverException(MessageUtil.getMessage("RESOLVER_UNABLE_TO_RESOLVE", app.getApplicationMetadata().getApplicationName(), reqList));
        re.setUnsatisfiedRequirements(unsatisfiedRequirements);
        log.debug("Method exit: {}, returning {}", (Object)"resolve", (Object)re);
        throw re;
    }

    public BundleInfo getBundleInfo(String bundleSymbolicName, Version bundleVersion) {
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put("version", bundleVersion.toString());
        String filterString = ManifestHeaderProcessor.generateFilter((String)"symbolicname", (String)bundleSymbolicName, attribs);
        try {
            Resource[] resources = this.repositoryAdmin.discoverResources(filterString);
            if (resources != null && resources.length > 0) {
                return this.toBundleInfo(resources[0], false);
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            log.error("Invalid filter", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlatformRepositories(Resolver obrResolver, String appName, PlatformRepository platformRepository) {
        Collection uris;
        log.debug("Method entry: {}, args {}", (Object)"addPlatformRepositories", (Object)new Object[]{obrResolver, appName});
        DataModelHelper helper = this.repositoryAdmin.getHelper();
        if (platformRepository != null && (uris = platformRepository.getPlatformRepositoryURLs()) != null && !uris.isEmpty()) {
            for (URI uri : uris) {
                InputStream is = null;
                try {
                    Resource[] resources;
                    is = uri.toURL().openStream();
                    InputStreamReader repoReader = new InputStreamReader(is);
                    Repository aPlatformRepo = helper.readRepository((Reader)repoReader);
                    for (Resource r : resources = aPlatformRepo.getResources()) {
                        Capability[] caps;
                        for (Capability c : caps = r.getCapabilities()) {
                            obrResolver.addGlobalCapability(c);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(MessageUtil.getMessage("RESOLVER_UNABLE_TO_READ_REPOSITORY_EXCEPTION", appName, uri));
                }
                finally {
                    IOUtils.close((Closeable)is);
                }
            }
        }
        log.debug("Method exit: {}, returning {}", (Object)"addPlatformRepositories");
    }

    private Resource createApplicationResource(String appName, Version appVersion, List<Content> appContent) {
        return new ApplicationResourceImpl(appName, appVersion, appContent);
    }

    private Resource createApplicationResource(String appName, String appVersion, Collection<ImportedBundle> inputs) {
        return new ApplicationResourceImpl(appName, Version.parseVersion((String)appVersion), inputs);
    }

    private BundleInfo toBundleInfo(Resource resource, boolean optional) {
        HashMap<String, String> directives = null;
        if (optional) {
            directives = new HashMap<String, String>();
            directives.put("resolution", "optional");
        }
        return new OBRBundleInfo(resource.getSymbolicName(), resource.getVersion(), resource.getURI(), null, null, null, null, null, null, directives, null);
    }

    protected List<Resource> retrieveRequiredResources(Resolver resolver) {
        log.debug("Method entry: {}, args {}", (Object)"retrieveRequiredResources", (Object)resolver);
        HashMap<String, List<Resource>> resourcesByName = new HashMap<String, List<Resource>>();
        for (Resource r : resolver.getRequiredResources()) {
            resourcesByName.put(r.getSymbolicName(), this.mergeResource(resolver, r, (List)resourcesByName.get(r.getSymbolicName())));
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (List res : resourcesByName.values()) {
            result.addAll(res);
        }
        log.debug("Method exit: {}, returning {}", (Object)"retrieveRequiredResources", result);
        return result;
    }

    protected List<Resource> mergeResource(Resolver resolver, Resource r, List<Resource> list) {
        log.debug("Method entry: {}, args {}", (Object)"mergeResource", (Object)new Object[]{resolver, r, list});
        if (list == null) {
            log.debug("Method exit: {}, returning {}", (Object)"mergeResource", Arrays.asList(r));
            return Arrays.asList(r);
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource old : list) {
            boolean oldRedundant = this.satisfiesAll(r, resolver.getReason(old));
            boolean newRedundant = this.satisfiesAll(old, resolver.getReason(r));
            if (oldRedundant && newRedundant) {
                int comp = old.getVersion().compareTo((Object)r.getVersion());
                oldRedundant = comp < 0;
                boolean bl = newRedundant = comp >= 0;
            }
            if (newRedundant) {
                log.debug("Method exit: {}, returning {}", (Object)"mergeResource", list);
                return list;
            }
            if (oldRedundant) continue;
            result.add(old);
        }
        result.add(r);
        log.debug("Method exit: {}, returning {}", (Object)"mergeResource", result);
        return result;
    }

    protected boolean satisfiesAll(Resource res, Reason[] reasons) {
        log.debug("Method entry: {}, args {}", (Object)"satisfiesAll", (Object)new Object[]{res, Arrays.toString(reasons)});
        ArrayList<Requirement> reqs = new ArrayList<Requirement>();
        for (Reason reason : reasons) {
            reqs.add(reason.getRequirement());
        }
        boolean result = true;
        for (Requirement r : reqs) {
            boolean found = false;
            for (Capability c : res.getCapabilities()) {
                if (!r.isSatisfied(c)) continue;
                found = true;
                break;
            }
            if (found || r.isOptional()) continue;
            result = false;
            break;
        }
        log.debug("Method exit: {}, returning {}", (Object)"satisfiesAll", (Object)result);
        return result;
    }

    private String extractConsumableMessageInfo(String filter, Set<String> bundlesFailing) {
        log.debug("Method entry: {}, args {}", (Object)"extractConsumableMessageInfo", (Object)new Object[]{filter, bundlesFailing});
        Map attrs = ManifestHeaderProcessor.parseFilter((String)filter);
        HashMap customAttrs = new HashMap();
        for (Map.Entry e : attrs.entrySet()) {
            if (SPECIAL_FILTER_ATTRS.contains(e.getKey())) continue;
            customAttrs.put(e.getKey(), e.getValue());
        }
        StringBuilder msgKey = new StringBuilder();
        ArrayList<Object> inserts = new ArrayList<Object>();
        boolean unknownType = false;
        if (attrs.containsKey("package")) {
            msgKey.append("RESOLVER_UNABLE_TO_RESOLVE_PACKAGE");
            inserts.add(attrs.get("package"));
        } else if (attrs.containsKey("symbolicname")) {
            msgKey.append("RESOLVER_UNABLE_TO_RESOLVE_BUNDLE");
            inserts.add(attrs.get("symbolicname"));
        } else if (attrs.containsKey("service")) {
            msgKey.append("RESOLVER_UNABLE_TO_RESOLVE_SERVICE");
        } else {
            unknownType = true;
            msgKey.append("RESOLVER_UNABLE_TO_RESOLVE_FILTER");
            inserts.add(filter);
        }
        if (bundlesFailing != null && bundlesFailing.size() != 0) {
            msgKey.append("_REQUIRED_BY_BUNDLE");
            if (bundlesFailing.size() == 1) {
                inserts.add(bundlesFailing.iterator().next());
            } else {
                inserts.add(bundlesFailing.toString());
            }
        }
        if (!unknownType && !customAttrs.isEmpty()) {
            msgKey.append("_WITH_ATTRS");
            inserts.add(customAttrs);
        }
        if (!unknownType && attrs.containsKey("version")) {
            msgKey.append("_WITH_VERSION");
            VersionRange vr = ManifestHeaderProcessor.parseVersionRange((String)((String)attrs.get("version")));
            inserts.add(vr.getMinimumVersion());
            if (!vr.isExactVersion()) {
                msgKey.append(vr.isMinimumExclusive() ? "_LOWEX" : "_LOW");
                if (vr.getMaximumVersion() != null) {
                    msgKey.append(vr.isMaximumExclusive() ? "_UPEX" : "_UP");
                    inserts.add(vr.getMaximumVersion());
                }
            }
        }
        String msgKeyStr = msgKey.toString();
        String msg = MessageUtil.getMessage(msgKeyStr, inserts.toArray());
        log.debug("Method exit: {}, returning {}", (Object)"extractConsumableMessageInfo", (Object)msg);
        return msg;
    }

    private Map<String, Set<String>> refineUnsatisfiedRequirements(Resolver resolver, Reason[] reasons) {
        log.debug("Method entry: {}, args {}", (Object)"refineUnsatisfiedRequirements", (Object)new Object[]{resolver, Arrays.toString(reasons)});
        HashMap<Requirement, HashSet<String>> req_resources = new HashMap<Requirement, HashSet<String>>();
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Reason reason : reasons) {
            resources.add(reason.getResource());
            Requirement key = reason.getRequirement();
            String value = reason.getResource().getSymbolicName() + "_" + reason.getResource().getVersion().toString();
            HashSet<String> values = (HashSet<String>)req_resources.get(key);
            if (values == null) {
                values = new HashSet<String>();
            }
            values.add(value);
            req_resources.put(key, values);
        }
        HashSet<Capability> caps = new HashSet<Capability>();
        for (Resource res : resources) {
            List<Capability> capList;
            if (res == null || res.getCapabilities() == null || (capList = Arrays.asList(res.getCapabilities())) == null) continue;
            caps.addAll(capList);
        }
        Iterator iterator = req_resources.entrySet().iterator();
        block2: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Requirement req = (Requirement)entry.getKey();
            for (Capability cap : caps) {
                if (!req.isSatisfied(cap)) continue;
                iterator.remove();
                continue block2;
            }
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry req_res : req_resources.entrySet()) {
            result.put(((Requirement)req_res.getKey()).getFilter(), (Set<String>)req_res.getValue());
        }
        log.debug("Method exit: {}, returning {}", (Object)"refineUnsatisfiedRequirements", (Object)new Object[]{result});
        return result;
    }

    private Collection<ImportedBundle> toImportedBundle(Collection<Content> content) throws ResolverException {
        log.debug("Method entry: {}, args {}", (Object)"toImportedBundle", content);
        ArrayList<ImportedBundle> result = new ArrayList<ImportedBundle>();
        for (Content c : content) {
            try {
                result.add(this.modellingManager.getImportedBundle(c.getContentName(), c.getVersion().toString()));
            }
            catch (InvalidAttributeException iae) {
                throw new ResolverException((Exception)((Object)iae));
            }
        }
        log.debug("Method exit: {}, returning {}", (Object)"toImportedBundle", result);
        return result;
    }

    private Collection<ModelledResource> toModelledResource(Collection<BundleInfo> bundleInfos) throws ResolverException {
        ArrayList<ModelledResource> result = new ArrayList<ModelledResource>();
        if (bundleInfos != null && !bundleInfos.isEmpty()) {
            for (BundleInfo bi : bundleInfos) {
                try {
                    result.add(this.modellingManager.getModelledResource(null, bi, null, null));
                }
                catch (InvalidAttributeException iae) {
                    throw new ResolverException((Exception)((Object)iae));
                }
            }
        }
        return result;
    }

    private Repository getLocalRepository(RepositoryAdmin admin) {
        Repository localRepository = this.repositoryAdmin.getLocalRepository();
        Resource[] resources = localRepository.getResources();
        Resource[] newResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            newResources[i] = new ResourceWrapper(resources[i]);
        }
        return this.repositoryAdmin.getHelper().repository(newResources);
    }

    private boolean excludeLocalRuntime() {
        return Boolean.parseBoolean(System.getProperty("provision.exclude.local.repository"));
    }
}

