/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.resolver.obr.impl;

import java.util.Hashtable;
import java.util.Map;
import org.apache.aries.application.modelling.Consumer;
import org.apache.aries.application.utils.FilterUtils;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequirementImpl
implements Requirement {
    private final Logger logger = LoggerFactory.getLogger(RequirementImpl.class);
    private final Consumer consumer;
    private final String name;
    private final String filter;
    private final boolean multiple;
    private final boolean optional;
    private final boolean extend;
    private final String comment;

    public RequirementImpl(String name, Filter filter, boolean multiple, boolean optional, boolean extend, String comment) {
        this.name = name;
        this.filter = filter.toString();
        this.multiple = multiple;
        this.optional = optional;
        this.extend = extend;
        this.comment = comment;
        this.consumer = null;
    }

    public RequirementImpl(Consumer consumer) {
        this.consumer = consumer;
        this.name = this.getName();
        this.filter = this.getFilter();
        this.multiple = this.isMultiple();
        this.optional = this.isOptional();
        this.extend = false;
        this.comment = this.getComment();
    }

    public String getComment() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getComment");
        if (this.consumer != null) {
            String cleanFilter = FilterUtils.removeMandatoryFilterToken((String)this.consumer.getAttributeFilter());
            Map atts = ManifestHeaderProcessor.parseFilter((String)cleanFilter);
            String comment = "Requires " + this.consumer.getType().toString() + " with attributes " + atts;
            this.logger.debug("Method exit: {}, returning {}", (Object)"getComment", (Object)comment);
            return comment;
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"getComment", (Object)this.comment);
        return this.comment;
    }

    public String getFilter() {
        String result = this.consumer != null ? this.consumer.getAttributeFilter() : this.filter;
        return result;
    }

    public String getName() {
        String result = this.consumer != null ? this.consumer.getType().toString() : this.name;
        return result;
    }

    public boolean isExtend() {
        return this.extend;
    }

    public boolean isMultiple() {
        boolean result = this.consumer != null ? this.consumer.isMultiple() : this.multiple;
        return result;
    }

    public boolean isOptional() {
        boolean result = this.consumer != null ? this.consumer.isOptional() : this.optional;
        return result;
    }

    public boolean isSatisfied(Capability cap) {
        this.logger.debug("Method entry: {}, args {}", (Object)"isSatisfied", (Object)cap);
        boolean result = false;
        String name = this.getName();
        if (name.equals(cap.getName())) {
            String filterToCreate = this.getFilter();
            try {
                Filter f = FrameworkUtil.createFilter((String)FilterUtils.removeMandatoryFilterToken((String)filterToCreate));
                Hashtable hash = new Hashtable();
                Map props = cap.getPropertiesAsMap();
                if (props != null && !props.isEmpty()) {
                    for (Map.Entry propertyPair : props.entrySet()) {
                        hash.put(propertyPair.getKey(), propertyPair.getValue());
                    }
                }
                result = f.match(hash);
            }
            catch (InvalidSyntaxException e) {
                this.logger.error(e.getMessage());
            }
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"isSatisfied", (Object)result);
        return result;
    }
}

