/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.aries.jpa.container.ManagedPersistenceUnitInfo;
import org.apache.aries.jpa.container.impl.CountingEntityManagerFactory;
import org.apache.aries.jpa.container.impl.DestroyCallback;
import org.apache.aries.jpa.container.impl.InvalidPersistenceUnitException;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFactoryManager {
    private final BundleContext containerContext;
    private final Bundle bundle;
    private ServiceReference provider;
    private Collection<ManagedPersistenceUnitInfo> persistenceUnits;
    private Collection<ParsedPersistenceUnit> parsedData;
    private Map<String, CountingEntityManagerFactory> emfs = null;
    private ConcurrentMap<String, ServiceRegistration> registrations = null;
    private boolean quiesce = false;
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");

    public EntityManagerFactoryManager(BundleContext containerCtx, Bundle b, Collection<ParsedPersistenceUnit> parsedUnits, ServiceReference ref, Collection<ManagedPersistenceUnitInfo> infos) {
        this.containerContext = containerCtx;
        this.bundle = b;
        this.provider = ref;
        this.persistenceUnits = infos;
        this.parsedData = parsedUnits;
    }

    public synchronized boolean providerRemoved(ServiceReference ref) {
        boolean toReturn = this.provider.equals(ref);
        if (toReturn) {
            this.destroy();
        }
        return toReturn;
    }

    public synchronized void bundleStateChange() throws InvalidPersistenceUnitException {
        switch (this.bundle.getState()) {
            case 4: {
                this.unregisterEntityManagerFactories();
                this.createEntityManagerFactories();
                break;
            }
            case 8: 
            case 32: {
                this.registerEntityManagerFactories();
                break;
            }
            case 16: {
                this.quiesce = false;
                this.unregisterEntityManagerFactories();
                break;
            }
            case 2: {
                this.destroyEntityManagerFactories();
            }
        }
    }

    private void unregisterEntityManagerFactories() {
        if (this.registrations != null) {
            for (Map.Entry entry : this.registrations.entrySet()) {
                try {
                    ((ServiceRegistration)entry.getValue()).unregister();
                }
                catch (Exception e) {
                    _logger.error("There was an error unregistering the EntityManagerFactory services for bundle " + this.bundle.getSymbolicName() + "_" + this.bundle.getVersion(), (Throwable)e);
                }
                this.emfs.get(entry.getKey()).clearQuiesce();
            }
            this.registrations = null;
        }
    }

    private void registerEntityManagerFactories() throws InvalidPersistenceUnitException {
        if (this.provider != null && this.registrations == null && !this.quiesce) {
            this.createEntityManagerFactories();
            this.registrations = new ConcurrentHashMap<String, ServiceRegistration>();
            String providerName = (String)this.provider.getProperty("javax.persistence.provider");
            if (providerName == null) {
                _logger.warn("The PersistenceProvider for bundle {} did not specify a provider name in the \"javax.persistence.provider\" service property. As a result EntityManagerFactory objects will not be registered with the osgi.unit.provider property. The Peristence Provider service was {}", new Object[]{this.bundle.getSymbolicName() + "_" + this.bundle.getVersion(), this.provider});
            }
            for (Map.Entry<String, CountingEntityManagerFactory> entry : this.emfs.entrySet()) {
                Properties props = new Properties();
                String unitName = entry.getKey();
                props.put("osgi.unit.name", unitName);
                if (providerName != null) {
                    props.put("osgi.unit.provider", providerName);
                }
                props.put("osgi.unit.version", this.provider.getBundle().getVersion());
                props.put("org.apache.aries.jpa.container.managed", Boolean.TRUE);
                props.put("org.apache.aries.jpa.default.unit.name", (Object)"".equals(unitName));
                try {
                    this.registrations.put(unitName, this.bundle.getBundleContext().registerService(EntityManagerFactory.class.getCanonicalName(), (Object)entry.getValue(), (Dictionary)props));
                }
                catch (Exception e) {
                    _logger.error("There was an error registering the persistence unit " + unitName + " defined by the bundle " + this.bundle.getSymbolicName() + "_" + this.bundle.getVersion(), (Throwable)e);
                    throw new InvalidPersistenceUnitException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEntityManagerFactories() throws InvalidPersistenceUnitException {
        if (this.provider != null && this.emfs == null && !this.quiesce) {
            try {
                this.emfs = new HashMap<String, CountingEntityManagerFactory>();
                PersistenceProvider providerService = (PersistenceProvider)this.containerContext.getService(this.provider);
                if (providerService == null) {
                    _logger.warn("The PersistenceProvider service hosting persistence units in bundle " + this.bundle.getSymbolicName() + "_" + this.bundle.getVersion() + " is no longer available. " + "Persistence units defined by the bundle will not be available until the bundle is refreshed");
                    throw new InvalidPersistenceUnitException();
                }
                for (ManagedPersistenceUnitInfo info : this.persistenceUnits) {
                    PersistenceUnitInfo pUnitInfo = info.getPersistenceUnitInfo();
                    this.emfs.put(pUnitInfo.getPersistenceUnitName(), new CountingEntityManagerFactory(providerService.createContainerEntityManagerFactory(pUnitInfo, info.getContainerProperties()), pUnitInfo.getPersistenceUnitName()));
                }
            }
            finally {
                this.containerContext.ungetService(this.provider);
            }
        }
    }

    public synchronized void manage(ServiceReference ref, Collection<ManagedPersistenceUnitInfo> infos) throws IllegalStateException {
        this.provider = ref;
        this.persistenceUnits = infos;
    }

    public synchronized void manage(Collection<ParsedPersistenceUnit> parsedUnits, ServiceReference ref, Collection<ManagedPersistenceUnitInfo> infos) throws IllegalStateException {
        this.parsedData = parsedUnits;
        this.provider = ref;
        this.persistenceUnits = infos;
    }

    public synchronized void destroy() {
        this.destroyEntityManagerFactories();
        this.provider = null;
        this.persistenceUnits = null;
    }

    private void destroyEntityManagerFactories() {
        if (this.registrations != null) {
            this.unregisterEntityManagerFactories();
        }
        if (this.emfs != null) {
            for (Map.Entry<String, CountingEntityManagerFactory> entry : this.emfs.entrySet()) {
                try {
                    ((EntityManagerFactory)entry.getValue()).close();
                }
                catch (Exception e) {
                    _logger.error("There was an exception when closing the EntityManagerFactory for persistence unit " + entry.getKey() + " in bundle " + this.bundle.getSymbolicName() + "_" + this.bundle.getVersion(), (Throwable)e);
                }
            }
        }
        this.emfs = null;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Collection<ParsedPersistenceUnit> getParsedPersistenceUnits() {
        return this.parsedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce(DestroyCallback countdown) {
        HashMap<CountingEntityManagerFactory, ServiceRegistration> entries = new HashMap<CountingEntityManagerFactory, ServiceRegistration>();
        ArrayList<String> names = new ArrayList<String>();
        EntityManagerFactoryManager entityManagerFactoryManager = this;
        synchronized (entityManagerFactoryManager) {
            if ((this.bundle.getState() & 0x28) != 0) {
                this.quiesce = true;
            }
            if (this.emfs != null) {
                for (String string : this.emfs.keySet()) {
                    entries.put(this.emfs.get(string), this.registrations != null ? (ServiceRegistration)this.registrations.get(string) : null);
                    names.add(string);
                }
            }
        }
        if (entries.isEmpty()) {
            countdown.callback();
        } else {
            NamedCallback callback = new NamedCallback(names, countdown);
            for (Map.Entry entry : entries.entrySet()) {
                CountingEntityManagerFactory emf = (CountingEntityManagerFactory)entry.getKey();
                emf.quiesce(callback, (ServiceRegistration)entry.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NamedCallback {
        private final Set<String> names;
        private final DestroyCallback callback;

        public NamedCallback(Collection<String> names, DestroyCallback countdown) {
            this.names = new HashSet<String>(names);
            this.callback = countdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(String name) {
            boolean winner;
            NamedCallback namedCallback = this;
            synchronized (namedCallback) {
                winner = !this.names.isEmpty() && this.names.remove(name) && this.names.isEmpty();
            }
            if (winner) {
                this.callback.callback();
            }
        }
    }
}

