/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.aries.jpa.container.impl.PersistenceDescriptorImpl;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceBundleHelper {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");
    public static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    public static final String PERSISTENCE_UNIT_HEADER = "Meta-Persistence";
    public static final String WEB_CONTEXT_PATH_HEADER = "Web-ContextPath";

    /*
     * WARNING - void declaration
     */
    public static Collection<PersistenceDescriptor> findPersistenceXmlFiles(Bundle bundle) {
        Collection<Object> locations;
        Dictionary headers = bundle.getHeaders();
        String metaPersistence = (String)headers.get(PERSISTENCE_UNIT_HEADER);
        String webContextPath = (String)headers.get(WEB_CONTEXT_PATH_HEADER);
        if (metaPersistence == null) {
            if (webContextPath == null) {
                return Collections.emptySet();
            }
            if (_logger.isInfoEnabled()) {
                _logger.info("The bundle " + bundle.getSymbolicName() + " specifies both the " + WEB_CONTEXT_PATH_HEADER + " header, but it does not specify the " + PERSISTENCE_UNIT_HEADER + " header." + " This bundle will be scanned for persistence descriptors in any locations defined by the JPA specification" + "that are on the Classpath.");
            }
            String bundleClassPath = (String)headers.get("Bundle-ClassPath");
            locations = PersistenceBundleHelper.findWABClassPathLocations(bundleClassPath);
        } else {
            locations = new HashSet<String>();
            locations.add(PERSISTENCE_XML);
            if (!metaPersistence.isEmpty()) {
                void var7_9;
                String[] arr$ = metaPersistence.split(",");
                int len$ = arr$.length;
                boolean bl = false;
                while (var7_9 < len$) {
                    String s = arr$[var7_9];
                    locations.add(s.trim());
                    ++var7_9;
                }
            }
        }
        Collection<PersistenceDescriptor> persistenceXmlFiles = new ArrayList<PersistenceDescriptor>();
        for (String string : locations) {
            try {
                InputStream file = PersistenceBundleHelper.locateFile(bundle, string);
                if (file == null) continue;
                persistenceXmlFiles.add(new PersistenceDescriptorImpl(string, file));
            }
            catch (Exception e) {
                _logger.error("There was an exception while locating the persistence descriptor at location " + string + " in bundle " + bundle.getSymbolicName() + "_" + bundle.getVersion() + ". No persistence descriptors will be processed for this bundle.", (Throwable)e);
                for (PersistenceDescriptor desc : persistenceXmlFiles) {
                    try {
                        desc.getInputStream().close();
                    }
                    catch (IOException ioe) {}
                }
                persistenceXmlFiles = Collections.emptySet();
                break;
            }
        }
        if (persistenceXmlFiles.isEmpty()) {
            _logger.warn("The bundle " + bundle.getSymbolicName() + "_" + bundle.getVersion() + " specified the Meta-Persistence header. However, no persistence descriptors " + "could be located. The following locations were searched: " + locations.toString());
        }
        return persistenceXmlFiles;
    }

    private static Collection<String> findWABClassPathLocations(String bundleClassPath) {
        HashSet<String> locations = new HashSet<String>();
        if (bundleClassPath == null || bundleClassPath.isEmpty()) {
            locations.add(PERSISTENCE_XML);
        } else {
            String[] entries;
            bundleClassPath = bundleClassPath.replaceAll(";[^;,]*?=\\s*\".*?\"", "");
            bundleClassPath = bundleClassPath.replaceAll(";[^;,]*?=[^;,]*", ",");
            bundleClassPath = bundleClassPath.replace(';', ',');
            bundleClassPath = bundleClassPath.replaceAll(",+", ",");
            for (String entry : entries = bundleClassPath.split(",")) {
                if ((entry = entry.trim()).isEmpty()) continue;
                if (".".equals(entry)) {
                    locations.add(PERSISTENCE_XML);
                    continue;
                }
                if (entry.endsWith(".jar")) {
                    locations.add(entry + "!/" + PERSISTENCE_XML);
                    continue;
                }
                if (!entry.endsWith("/")) {
                    entry = entry + "/";
                }
                locations.add(entry + PERSISTENCE_XML);
            }
        }
        return locations;
    }

    private static InputStream locateFile(Bundle bundle, String location) throws IOException {
        InputStream is = null;
        if ("".equals(location)) {
            return null;
        }
        int bangIndex = location.indexOf(33);
        if (bangIndex == -1) {
            URL url = bundle.getEntry(location);
            if (url != null) {
                is = url.openStream();
            }
        } else {
            URL url = bundle.getEntry(location.substring(0, bangIndex));
            if (url != null) {
                String toLocate = location.substring(bangIndex + 2);
                JarInputStream jis = new JarInputStream(url.openStream());
                JarEntry entry = jis.getNextJarEntry();
                while (entry != null) {
                    if (entry.getName().equals(toLocate)) {
                        is = jis;
                        break;
                    }
                    entry = jis.getNextJarEntry();
                }
            }
        }
        return is;
    }
}

