/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.aries.jpa.container.impl.DestroyCallback;
import org.apache.aries.jpa.container.impl.PersistenceBundleManager;
import org.apache.aries.quiesce.manager.QuiesceCallback;
import org.apache.aries.quiesce.participant.QuiesceParticipant;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuiesceParticipantImpl
implements QuiesceParticipant,
DestroyCallback {
    private static final int QUIESCABLE_BUNDLE = 56;
    private final ExecutorService executor = new ThreadPoolExecutor(0, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "JPA-Container-ThreadPool");
            t.setDaemon(true);
            return t;
        }
    });
    private final PersistenceBundleManager mgr;
    private final BlockingQueue<DestroyCallback> unhandledQuiesces = new LinkedBlockingQueue<DestroyCallback>();

    public QuiesceParticipantImpl(PersistenceBundleManager mgr) {
        this.mgr = mgr;
    }

    public void quiesce(QuiesceCallback qc, List<Bundle> arg1) {
        for (Bundle b : arg1) {
            try {
                if ((b.getState() & 0x38) == 0) {
                    qc.bundleQuiesced(new Bundle[]{b});
                } else {
                    this.executor.execute(new QuiesceBundle(qc, b, this.mgr));
                }
            }
            catch (RejectedExecutionException re) {
                this.unhandledQuiesces.add(new QuiesceDelegatingCallback(qc, b));
            }
            if (!b.equals(this.mgr.getCtx().getBundle())) continue;
            this.executor.shutdown();
        }
    }

    @Override
    public void callback() {
        this.executor.shutdown();
        try {
            for (DestroyCallback cbk : this.unhandledQuiesces) {
                cbk.callback();
            }
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executor.shutdownNow();
    }

    private static final class QuiesceBundle
    implements Runnable {
        private final DestroyCallback callback;
        private final Bundle bundleToQuiesce;
        private final PersistenceBundleManager mgr;

        public QuiesceBundle(QuiesceCallback callback, Bundle bundleToQuiesce, PersistenceBundleManager mgr) {
            this.callback = new QuiesceDelegatingCallback(callback, bundleToQuiesce);
            this.bundleToQuiesce = bundleToQuiesce;
            this.mgr = mgr;
        }

        public void run() {
            this.mgr.quiesceBundle(this.bundleToQuiesce, this.callback);
        }
    }

    private static final class QuiesceDelegatingCallback
    implements DestroyCallback {
        private final QuiesceCallback callback;
        private final Bundle toQuiesce;

        public QuiesceDelegatingCallback(QuiesceCallback cbk, Bundle b) {
            this.callback = cbk;
            this.toQuiesce = b;
        }

        public void callback() {
            this.callback.bundleQuiesced(new Bundle[]{this.toQuiesce});
        }
    }
}

