/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parsing.impl;

import java.util.Collection;
import java.util.Stack;
import org.apache.aries.jpa.container.parsing.impl.PersistenceUnitImpl;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAHandler
extends DefaultHandler {
    private final Stack<PersistenceUnitImpl> persistenceUnits = new Stack();
    private String elementName;
    private final String jpaVersion;
    private StringBuilder builder = new StringBuilder();
    private Bundle bundle;

    public JPAHandler(Bundle b, String version) {
        this.bundle = b;
        this.jpaVersion = version;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.builder.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String string = this.elementName = localName == null || "".equals(localName) ? name : localName;
        if ("persistence-unit".equals(this.elementName)) {
            this.persistenceUnits.push(new PersistenceUnitImpl(this.bundle, attributes.getValue("name"), attributes.getValue("transaction-type"), this.jpaVersion));
        } else if ("exclude-unlisted-classes".equals(this.elementName)) {
            this.persistenceUnits.peek().setExcludeUnlisted(true);
        } else if ("property".equals(this.elementName)) {
            this.persistenceUnits.peek().addProperty(attributes.getValue("name"), attributes.getValue("value"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        String s = this.builder.toString().trim();
        this.builder = new StringBuilder();
        if ("".equals(s)) {
            return;
        }
        PersistenceUnitImpl pu = this.persistenceUnits.peek();
        if ("provider".equals(this.elementName)) {
            pu.setProviderClassName(s);
        } else if ("jta-data-source".equals(this.elementName)) {
            pu.setJtaDataSource(s);
        } else if ("non-jta-data-source".equals(this.elementName)) {
            pu.setNonJtaDataSource(s);
        } else if ("mapping-file".equals(this.elementName)) {
            pu.addMappingFileName(s);
        } else if ("jar-file".equals(this.elementName)) {
            pu.addJarFileName(s);
        } else if ("class".equals(this.elementName)) {
            pu.addClassName(s);
        } else if ("exclude-unlisted-classes".equals(this.elementName)) {
            pu.setExcludeUnlisted(Boolean.parseBoolean(s));
        } else if ("2.0".equals(this.jpaVersion) && "shared-cache-mode".equals(this.elementName)) {
            pu.setSharedCacheMode(s);
        } else if ("2.0".equals(this.jpaVersion) && "validation-mode".equals(this.elementName)) {
            pu.setValidationMode(s);
        }
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        throw spe;
    }

    public Collection<PersistenceUnitImpl> getPersistenceUnits() {
        return this.persistenceUnits;
    }
}

