/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.unit.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayedLookupDataSource
implements DataSource {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");
    private DataSource ds = null;
    private final String jndiName;
    private final Bundle persistenceBundle;

    private DataSource getDs() {
        if (this.ds == null) {
            try {
                Hashtable<String, BundleContext> props = new Hashtable<String, BundleContext>();
                BundleContext bCtx = this.persistenceBundle.getBundleContext();
                if (bCtx == null) {
                    throw new IllegalStateException("The bundle " + this.persistenceBundle.getSymbolicName() + "_" + this.persistenceBundle.getVersion() + " is not started.");
                }
                props.put("osgi.service.jndi.bundleContext", bCtx);
                InitialContext ctx = new InitialContext(props);
                this.ds = (DataSource)ctx.lookup(this.jndiName);
            }
            catch (NamingException e) {
                _logger.error("No JTA datasource could be located using the JNDI name " + this.jndiName, (Throwable)e);
                throw new RuntimeException("The DataSource " + this.jndiName + " could not be used.", e);
            }
        }
        return this.ds;
    }

    public DelayedLookupDataSource(String jndi, Bundle persistenceBundle) {
        this.jndiName = jndi;
        this.persistenceBundle = persistenceBundle;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDs().getConnection();
    }

    @Override
    public Connection getConnection(String theUsername, String thePassword) throws SQLException {
        return this.getDs().getConnection(theUsername, thePassword);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDs().getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDs().getLogWriter();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDs().isWrapperFor(iface);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDs().setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDs().setLogWriter(out);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getDs().unwrap(iface);
    }
}

