/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.unit.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.apache.aries.jpa.container.unit.impl.BundleDelegatingClassLoader;
import org.apache.aries.jpa.container.unit.impl.DelayedLookupDataSource;
import org.apache.aries.jpa.container.unit.impl.TempBundleDelegatingClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private final Bundle bundle;
    private final ParsedPersistenceUnit unit;
    private final BundleDelegatingClassLoader cl;
    private final ServiceReference providerRef;
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");

    public PersistenceUnitInfoImpl(Bundle b, ParsedPersistenceUnit parsedData, ServiceReference providerRef) {
        this.bundle = b;
        this.unit = parsedData;
        this.providerRef = providerRef;
        this.cl = new BundleDelegatingClassLoader(b);
    }

    public void addTransformer(ClassTransformer arg0) {
    }

    public boolean excludeUnlistedClasses() {
        Boolean result = (Boolean)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.exclude.unlisted");
        return result == null ? false : result;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public List<URL> getJarFileUrls() {
        List jarFiles = (List)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.jar.files");
        ArrayList<URL> urls = new ArrayList<URL>();
        if (jarFiles != null) {
            for (String jarFile : jarFiles) {
                URL url = this.bundle.getResource(jarFile);
                if (url == null) {
                    _logger.error("The persistence unit {} in bundle {} listed the jar file {}, but {} could not be found in the bundle", new Object[]{this.getPersistenceUnitName(), this.bundle.getSymbolicName() + "_" + this.bundle.getVersion(), jarFile, jarFile});
                    continue;
                }
                urls.add(url);
            }
        }
        return urls;
    }

    public DataSource getJtaDataSource() {
        String jndiString = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.jta.datasource");
        DelayedLookupDataSource toReturn = null;
        if (jndiString != null) {
            toReturn = new DelayedLookupDataSource(jndiString, this.bundle);
        }
        return toReturn;
    }

    public List<String> getManagedClassNames() {
        ArrayList classes = (ArrayList)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.managed.classes");
        if (classes == null) {
            classes = new ArrayList();
        }
        return Collections.unmodifiableList(classes);
    }

    public List<String> getMappingFileNames() {
        ArrayList mappingFiles = (ArrayList)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.mapping.files");
        if (mappingFiles == null) {
            mappingFiles = new ArrayList();
        }
        return Collections.unmodifiableList(mappingFiles);
    }

    public ClassLoader getNewTempClassLoader() {
        return new TempBundleDelegatingClassLoader(this.bundle, (ClassLoader)new BundleDelegatingClassLoader(this.providerRef.getBundle()));
    }

    public DataSource getNonJtaDataSource() {
        String jndiString = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.non.jta.datasource");
        DelayedLookupDataSource toReturn = null;
        if (jndiString != null) {
            toReturn = new DelayedLookupDataSource(jndiString, this.bundle);
        }
        return toReturn;
    }

    public String getPersistenceProviderClassName() {
        return (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.provider");
    }

    public String getPersistenceUnitName() {
        return (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.unit.name");
    }

    public URL getPersistenceUnitRootUrl() {
        return this.bundle.getResource("/");
    }

    public String getPersistenceXMLSchemaVersion() {
        return (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.schema.version");
    }

    public Properties getProperties() {
        return (Properties)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.properties");
    }

    public SharedCacheMode getSharedCacheMode() {
        String s = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa2.shared.cache.mode");
        if (s == null) {
            return SharedCacheMode.UNSPECIFIED;
        }
        return SharedCacheMode.valueOf((String)s);
    }

    public PersistenceUnitTransactionType getTransactionType() {
        String s = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa.transaction.type");
        if (s == null) {
            return PersistenceUnitTransactionType.JTA;
        }
        return PersistenceUnitTransactionType.valueOf((String)s);
    }

    public ValidationMode getValidationMode() {
        String s = (String)this.unit.getPersistenceXmlMetadata().get("org.apache.aries.jpa2.validation.mode");
        if (s == null) {
            return ValidationMode.AUTO;
        }
        return ValidationMode.valueOf((String)s);
    }
}

