/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.unit.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempBundleDelegatingClassLoader
extends ClassLoader {
    private final Bundle bundle;

    public TempBundleDelegatingClassLoader(Bundle b, ClassLoader parent) {
        super(parent);
        this.bundle = b;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        String classResName = className.replace('.', '/').concat(".class");
        InputStream is = this.getResourceAsStream(classResName);
        if (is == null) {
            throw new ClassNotFoundException(className);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        try {
            int read = is.read(buff);
            while (read > 0) {
                baos.write(buff, 0, read);
                read = is.read(buff);
            }
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(className, ioe);
        }
        buff = baos.toByteArray();
        return this.defineClass(className, buff, 0, buff.length);
    }

    @Override
    protected URL findResource(final String resName) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return TempBundleDelegatingClassLoader.this.bundle.getResource(resName);
            }
        });
    }

    @Override
    protected Enumeration<URL> findResources(final String resName) throws IOException {
        Enumeration<URL> resources = null;
        try {
            resources = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() throws IOException {
                    return TempBundleDelegatingClassLoader.this.bundle.getResources(resName);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception thrownException = pae.getException();
            if (thrownException instanceof IOException) {
                throw (IOException)thrownException;
            }
            throw new UndeclaredThrowableException(thrownException);
        }
        return resources;
    }
}

