/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.domain.RegionNameAndIngressRules;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.util.Preconditions2;

@Singleton
public class EC2ComputeService
extends BaseComputeService {
    private final EC2Client ec2Client;
    private final ConcurrentMap<RegionAndName, KeyPair> credentialsMap;
    private final LoadingCache<RegionAndName, String> securityGroupMap;

    @Inject
    protected EC2ComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, Provider<TemplateOptions> templateOptionsProvider, @Named(value="NODE_RUNNING") Predicate<NodeMetadata> nodeRunning, @Named(value="NODE_TERMINATED") Predicate<NodeMetadata> nodeTerminated, @Named(value="NODE_SUSPENDED") Predicate<NodeMetadata> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ExecutorService executor, EC2Client ec2Client, ConcurrentMap<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") LoadingCache<RegionAndName, String> securityGroupMap) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, executor);
        this.ec2Client = ec2Client;
        this.credentialsMap = credentialsMap;
        this.securityGroupMap = securityGroupMap;
    }

    @VisibleForTesting
    void deleteSecurityGroup(String region, String group) {
        Preconditions2.checkNotEmpty((String)group, (String)"group");
        String groupName = String.format("jclouds#%s#%s", group, region);
        if (this.ec2Client.getSecurityGroupServices().describeSecurityGroupsInRegion(region, groupName).size() > 0) {
            this.logger.debug(">> deleting securityGroup(%s)", new Object[]{groupName});
            try {
                this.ec2Client.getSecurityGroupServices().deleteSecurityGroupInRegion(region, groupName);
                this.securityGroupMap.invalidate((Object)new RegionNameAndIngressRules(region, groupName, null, false));
                this.logger.debug("<< deleted securityGroup(%s)", new Object[]{groupName});
            }
            catch (IllegalStateException e) {
                this.logger.debug("<< inUse securityGroup(%s)", new Object[]{groupName});
            }
        }
    }

    @VisibleForTesting
    void deleteKeyPair(String region, String group) {
        for (KeyPair keyPair : this.ec2Client.getKeyPairServices().describeKeyPairsInRegion(region, new String[0])) {
            if (!keyPair.getKeyName().equals("jclouds#" + group) && !keyPair.getKeyName().matches(String.format("jclouds#%s#%s", group, "[0-9a-f]+")) && !keyPair.getKeyName().matches(String.format("jclouds#%s#%s#%s", group, region, "[0-9a-f]+"))) continue;
            ImmutableSet<String> instancesUsingKeyPair = this.extractIdsFromInstances(Iterables.filter((Iterable)Iterables.concat(this.ec2Client.getInstanceServices().describeInstancesInRegion(region, new String[0])), this.usingKeyPairAndNotDead(keyPair)));
            if (instancesUsingKeyPair.size() > 0) {
                this.logger.debug("<< inUse keyPair(%s), by (%s)", new Object[]{keyPair.getKeyName(), instancesUsingKeyPair});
                continue;
            }
            this.logger.debug(">> deleting keyPair(%s)", new Object[]{keyPair.getKeyName()});
            this.ec2Client.getKeyPairServices().deleteKeyPairInRegion(region, keyPair.getKeyName());
            this.credentialsMap.remove(new RegionAndName(region, keyPair.getKeyName()));
            this.credentialsMap.remove(new RegionAndName(region, group));
            this.logger.debug("<< deleted keyPair(%s)", new Object[]{keyPair.getKeyName()});
        }
    }

    protected ImmutableSet<String> extractIdsFromInstances(Iterable<? extends RunningInstance> deadOnes) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(deadOnes, (Function)new Function<RunningInstance, String>(){

            public String apply(RunningInstance input) {
                return input.getId();
            }
        }));
    }

    protected Predicate<RunningInstance> usingKeyPairAndNotDead(final KeyPair keyPair) {
        return new Predicate<RunningInstance>(){

            public boolean apply(RunningInstance input) {
                switch (input.getInstanceState()) {
                    case TERMINATED: 
                    case SHUTTING_DOWN: {
                        return false;
                    }
                }
                return keyPair.getKeyName().equals(input.getKeyName());
            }
        };
    }

    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> filter) {
        Set deadOnes = super.destroyNodesMatching(filter);
        ImmutableMultimap.Builder regionGroups = ImmutableMultimap.builder();
        for (NodeMetadata nodeMetadata : deadOnes) {
            if (nodeMetadata.getGroup() == null) continue;
            regionGroups.put((Object)AWSUtils.parseHandle((String)nodeMetadata.getId())[0], (Object)nodeMetadata.getGroup());
        }
        for (Map.Entry regionGroup : regionGroups.build().entries()) {
            this.cleanUpIncidentalResources(regionGroup);
        }
        return deadOnes;
    }

    protected void cleanUpIncidentalResources(Map.Entry<String, String> regionGroup) {
        this.deleteKeyPair(regionGroup.getKey(), regionGroup.getValue());
        this.deleteSecurityGroup(regionGroup.getKey(), regionGroup.getValue());
    }

    public EC2TemplateOptions templateOptions() {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.templateOptions());
    }
}

