/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.config;

import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.concurrent.RetryOnTimeOutExceptionSupplier;
import org.jclouds.ec2.compute.config.EC2BindComputeStrategiesByClass;
import org.jclouds.ec2.compute.config.EC2BindComputeSuppliersByClass;
import org.jclouds.ec2.compute.config.EC2ComputeServiceDependenciesModule;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.RegionAndIdToImage;
import org.jclouds.ec2.compute.suppliers.RegionAndNameToImageSupplier;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.SetAndThrowAuthorizationExceptionSupplier;

public class EC2ComputeServiceContextModule
extends BaseComputeServiceContextModule {
    protected void configure() {
        this.installDependencies();
        this.install((Module)new EC2BindComputeStrategiesByClass());
        this.install((Module)new EC2BindComputeSuppliersByClass());
        super.configure();
    }

    protected void installDependencies() {
        this.install((Module)new EC2ComputeServiceDependenciesModule());
    }

    protected boolean shouldParseImagesOnDemand(Injector injector) {
        String[] amiOwners = (String[])injector.getInstance(Key.get(String[].class, (Annotation)Names.named((String)"jclouds.ec2.ami-owners")));
        return amiOwners.length > 0;
    }

    protected Supplier<Set<? extends Image>> supplyNonParsingImageCache(@Named(value="jclouds.session-interval") long seconds, Supplier<Set<? extends Image>> imageSupplier, Injector injector) {
        final Supplier cache = (Supplier)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<LoadingCache<RegionAndName, ? extends Image>>>(){}));
        return new Supplier<Set<? extends Image>>(){

            public Set<? extends Image> get() {
                return ImmutableSet.copyOf(((LoadingCache)cache.get()).asMap().values());
            }
        };
    }

    @Provides
    @Singleton
    protected Supplier<LoadingCache<RegionAndName, ? extends Image>> provideRegionAndNameToImageSupplierCache(RegionAndNameToImageSupplier supplier) {
        return supplier;
    }

    @Provides
    @Singleton
    protected Supplier<CacheLoader<RegionAndName, Image>> provideRegionAndNameToImageSupplierCacheLoader(final RegionAndIdToImage delegate) {
        return Suppliers.ofInstance((Object)new CacheLoader<RegionAndName, Image>(){
            private final AtomicReference<AuthorizationException> authException = new AtomicReference();

            public Image load(final RegionAndName key) throws Exception {
                Supplier<Image> rawSupplier = new Supplier<Image>(){

                    public Image get() {
                        try {
                            return delegate.load(key);
                        }
                        catch (ExecutionException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                };
                RetryOnTimeOutExceptionSupplier retryingSupplier = new RetryOnTimeOutExceptionSupplier((Supplier)new SetAndThrowAuthorizationExceptionSupplier((Supplier)rawSupplier, this.authException));
                return (Image)retryingSupplier.get();
            }
        });
    }

    @Provides
    @Singleton
    @Named(value="jclouds.ec2.ami-owners")
    String[] amiOwners(@Named(value="jclouds.ec2.ami-owners") String amiOwners) {
        if (amiOwners.trim().equals("")) {
            return new String[0];
        }
        return (String[])Iterables.toArray((Iterable)Splitter.on((char)',').split((CharSequence)amiOwners), String.class);
    }
}

