/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.domain.Image;
import org.jclouds.logging.Logger;

@Singleton
public class EC2ImageParser
implements Function<org.jclouds.ec2.domain.Image, Image> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final PopulateDefaultLoginCredentialsForImageStrategy credentialProvider;
    private final Supplier<Set<? extends Location>> locations;
    private final Supplier<Location> defaultLocation;
    private final Map<OsFamily, Map<String, String>> osVersionMap;
    private final ReviseParsedImage reviseParsedImage;

    @Inject
    public EC2ImageParser(PopulateDefaultLoginCredentialsForImageStrategy credentialProvider, Map<OsFamily, Map<String, String>> osVersionMap, @Memoized Supplier<Set<? extends Location>> locations, Supplier<Location> defaultLocation, ReviseParsedImage reviseParsedImage) {
        this.credentialProvider = (PopulateDefaultLoginCredentialsForImageStrategy)Preconditions.checkNotNull((Object)credentialProvider, (Object)"credentialProvider");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.defaultLocation = (Supplier)Preconditions.checkNotNull(defaultLocation, (Object)"defaultLocation");
        this.osVersionMap = (Map)Preconditions.checkNotNull(osVersionMap, (Object)"osVersionMap");
        this.reviseParsedImage = (ReviseParsedImage)Preconditions.checkNotNull((Object)reviseParsedImage, (Object)"reviseParsedImage");
    }

    public Image apply(final org.jclouds.ec2.domain.Image from) {
        if (from.getImageType() != Image.ImageType.MACHINE) {
            return null;
        }
        ImageBuilder builder = new ImageBuilder();
        builder.providerId(from.getId());
        builder.id(from.getRegion() + "/" + from.getId());
        builder.description(from.getDescription() != null ? from.getDescription() : from.getImageLocation());
        builder.userMetadata((Map)ImmutableMap.builder().put((Object)"owner", (Object)from.getImageOwnerId()).put((Object)"rootDeviceType", (Object)from.getRootDeviceType().value()).put((Object)"virtualizationType", (Object)from.getVirtualizationType().value()).put((Object)"hypervisor", (Object)from.getHypervisor().value()).build());
        OperatingSystem.Builder osBuilder = OperatingSystem.builder();
        osBuilder.is64Bit(from.getArchitecture() == Image.Architecture.X86_64);
        OsFamily family = ComputeServiceUtils.parseOsFamilyOrUnrecognized((String)from.getImageLocation());
        osBuilder.family(family);
        osBuilder.version(ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)family, (String)from.getImageLocation(), this.osVersionMap));
        osBuilder.description(from.getImageLocation());
        osBuilder.arch(from.getVirtualizationType().value());
        this.reviseParsedImage.reviseParsedImage(from, builder, family, osBuilder);
        builder.defaultCredentials(this.credentialProvider.apply((Object)from));
        try {
            builder.location((Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)new Predicate<Location>(){

                public boolean apply(Location input) {
                    return input.getId().equals(from.getRegion());
                }
            }));
        }
        catch (NoSuchElementException e) {
            this.logger.error("unknown region %s for image %s; not in %s", new Object[]{from.getRegion(), from.getId(), this.locations});
            builder.location(new LocationBuilder().scope(LocationScope.REGION).id(from.getRegion()).description(from.getRegion()).parent((Location)this.defaultLocation.get()).build());
        }
        builder.operatingSystem(osBuilder.build());
        return builder.build();
    }
}

