/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.compute.functions.ImagesToRegionAndIdMap;
import org.jclouds.ec2.compute.strategy.DescribeImagesParallel;
import org.jclouds.ec2.options.DescribeImagesOptions;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class EC2ImageSupplier
implements Supplier<Set<? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Set<String> regions;
    private final DescribeImagesParallel describer;
    private final String[] amiOwners;
    private final EC2ImageParser parser;
    private final Supplier<LoadingCache<RegionAndName, ? extends Image>> cache;

    @Inject
    protected EC2ImageSupplier(@Region Set<String> regions, DescribeImagesParallel describer, @Named(value="jclouds.ec2.ami-owners") String[] amiOwners, Supplier<LoadingCache<RegionAndName, ? extends Image>> cache, EC2ImageParser parser) {
        this.regions = regions;
        this.describer = describer;
        this.amiOwners = amiOwners;
        this.cache = cache;
        this.parser = parser;
    }

    public Set<? extends Image> get() {
        if (this.amiOwners.length == 0) {
            this.logger.debug(">> no owners specified, skipping image parsing", new Object[0]);
            return Collections.emptySet();
        }
        this.logger.debug(">> providing images", new Object[0]);
        Iterable<Map.Entry<String, DescribeImagesOptions>> queries = this.getDescribeQueriesForOwnersInRegions(this.regions, this.amiOwners);
        ImmutableSet parsedImages = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(this.describer.apply(queries), (Function)this.parser), (Predicate)Predicates.notNull()));
        Map<RegionAndName, ? extends Image> imageMap = ImagesToRegionAndIdMap.imagesToMap((Iterable<? extends Image>)parsedImages);
        ((LoadingCache)this.cache.get()).invalidateAll();
        ((LoadingCache)this.cache.get()).asMap().putAll(imageMap);
        this.logger.debug("<< images(%d)", new Object[]{imageMap.size()});
        return Sets.newLinkedHashSet(imageMap.values());
    }

    public Iterable<Map.Entry<String, DescribeImagesOptions>> getDescribeQueriesForOwnersInRegions(Set<String> regions, String[] amiOwners) {
        DescribeImagesOptions options = this.getOptionsForOwners(amiOwners);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String region : regions) {
            builder.put((Object)region, (Object)options);
        }
        return builder.build().entrySet();
    }

    public DescribeImagesOptions getOptionsForOwners(String ... amiOwners) {
        DescribeImagesOptions options = amiOwners.length == 1 && amiOwners[0].equals("*") ? new DescribeImagesOptions() : DescribeImagesOptions.Builder.ownedBy(amiOwners);
        return options;
    }
}

