/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.config.WithZonesFormSigningRestClientModule;
import org.jclouds.ec2.EC2AsyncClient;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.ec2.services.AMIAsyncClient;
import org.jclouds.ec2.services.AMIClient;
import org.jclouds.ec2.services.AvailabilityZoneAndRegionAsyncClient;
import org.jclouds.ec2.services.AvailabilityZoneAndRegionClient;
import org.jclouds.ec2.services.ElasticBlockStoreAsyncClient;
import org.jclouds.ec2.services.ElasticBlockStoreClient;
import org.jclouds.ec2.services.ElasticIPAddressAsyncClient;
import org.jclouds.ec2.services.ElasticIPAddressClient;
import org.jclouds.ec2.services.InstanceAsyncClient;
import org.jclouds.ec2.services.InstanceClient;
import org.jclouds.ec2.services.KeyPairAsyncClient;
import org.jclouds.ec2.services.KeyPairClient;
import org.jclouds.ec2.services.SecurityGroupAsyncClient;
import org.jclouds.ec2.services.SecurityGroupClient;
import org.jclouds.ec2.services.WindowsAsyncClient;
import org.jclouds.ec2.services.WindowsClient;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.RequiresHttp;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.logging.Logger;
import org.jclouds.rest.ConfiguresRestClient;

@RequiresHttp
@ConfiguresRestClient
public class EC2RestClientModule<S extends EC2Client, A extends EC2AsyncClient>
extends WithZonesFormSigningRestClientModule<S, A> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(AMIClient.class, AMIAsyncClient.class).put(ElasticIPAddressClient.class, ElasticIPAddressAsyncClient.class).put(InstanceClient.class, InstanceAsyncClient.class).put(KeyPairClient.class, KeyPairAsyncClient.class).put(SecurityGroupClient.class, SecurityGroupAsyncClient.class).put(WindowsClient.class, WindowsAsyncClient.class).put(AvailabilityZoneAndRegionClient.class, AvailabilityZoneAndRegionAsyncClient.class).put(ElasticBlockStoreClient.class, ElasticBlockStoreAsyncClient.class).build();

    public static EC2RestClientModule<EC2Client, EC2AsyncClient> create() {
        return new EC2RestClientModule<EC2Client, EC2AsyncClient>(EC2Client.class, EC2AsyncClient.class, DELEGATE_MAP);
    }

    public EC2RestClientModule(Class<S> sync, Class<A> async, Map<Class<?>, Class<?>> delegateMap) {
        super(sync, async, delegateMap);
    }

    protected void bindRegionsToProvider() {
        this.bindRegionsToProvider(RegionIdsToURI.class);
    }

    protected void bindZonesToProvider() {
        this.bindZonesToProvider(RegionIdToZoneId.class);
    }

    @Singleton
    public static class RegionIdToZoneId
    implements Provider<Map<String, String>> {
        @Resource
        protected Logger logger = Logger.NULL;
        private final AvailabilityZoneAndRegionClient client;
        private final Map<String, URI> regions;

        @Inject
        public RegionIdToZoneId(EC2Client client, @Region Map<String, URI> regions) {
            this.client = client.getAvailabilityZoneAndRegionServices();
            this.regions = regions;
        }

        @Singleton
        @Zone
        public Map<String, String> get() {
            ImmutableMap.Builder map = ImmutableMap.builder();
            HttpResponseException exception = null;
            for (Map.Entry<String, URI> region : this.regions.entrySet()) {
                try {
                    for (AvailabilityZoneInfo zoneInfo : this.client.describeAvailabilityZonesInRegion(region.getKey(), new DescribeAvailabilityZonesOptions[0])) {
                        map.put((Object)zoneInfo.getZone(), (Object)region.getKey());
                    }
                }
                catch (HttpResponseException e) {
                    if (e.getMessage().contains("Unable to tunnel through proxy")) {
                        exception = e;
                        this.logger.error((Throwable)e, "Could not describe availability zones in Region: %s", new Object[]{region.getKey()});
                        continue;
                    }
                    throw e;
                }
            }
            ImmutableMap result = map.build();
            if (result.isEmpty() && exception != null) {
                throw exception;
            }
            return result;
        }
    }

    @Singleton
    public static class RegionIdsToURI
    implements Provider<Map<String, URI>> {
        private final AvailabilityZoneAndRegionClient client;
        private final Injector injector;

        @Inject
        public RegionIdsToURI(EC2Client client, Injector injector) {
            this.client = client.getAvailabilityZoneAndRegionServices();
            this.injector = injector;
        }

        @Singleton
        @Region
        public Map<String, URI> get() {
            try {
                String regionString = (String)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"jclouds.regions")));
                ImmutableSet regions = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)regionString));
                if (regions.size() > 0) {
                    return Maps.filterKeys(this.client.describeRegions(new DescribeRegionsOptions[0]), (Predicate)Predicates.in((Collection)regions));
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            return this.client.describeRegions(new DescribeRegionsOptions[0]);
        }
    }
}

