/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.javax.annotation.Nullable;

public class Reservation<T extends RunningInstance>
extends LinkedHashSet<T>
implements Comparable<Reservation<T>>,
Set<T> {
    private static final long serialVersionUID = -9051777593518861395L;
    private final String region;
    private final Set<String> groupIds = Sets.newLinkedHashSet();
    @Nullable
    private final String ownerId;
    @Nullable
    private final String requesterId;
    @Nullable
    private final String reservationId;

    public Reservation(String region, Iterable<String> groupIds, Iterable<T> instances, @Nullable String ownerId, @Nullable String requesterId, @Nullable String reservationId) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        Iterables.addAll(this.groupIds, (Iterable)((Iterable)Preconditions.checkNotNull(groupIds, (Object)"groupIds")));
        Iterables.addAll((Collection)this, (Iterable)((Iterable)Preconditions.checkNotNull(instances, (Object)"instances")));
        this.ownerId = ownerId;
        this.requesterId = requesterId;
        this.reservationId = reservationId;
    }

    public String getRegion() {
        return this.region;
    }

    @Override
    public int compareTo(Reservation<T> o) {
        return this == o ? 0 : this.getReservationId().compareTo(o.getReservationId());
    }

    public Set<String> getGroupIds() {
        return this.groupIds;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.groupIds == null ? 0 : ((Object)this.groupIds).hashCode());
        result = 31 * result + (this.ownerId == null ? 0 : this.ownerId.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.requesterId == null ? 0 : this.requesterId.hashCode());
        result = 31 * result + (this.reservationId == null ? 0 : this.reservationId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reservation other = (Reservation)obj;
        if (this.groupIds == null ? other.groupIds != null : !((Object)this.groupIds).equals(other.groupIds)) {
            return false;
        }
        if (this.ownerId == null ? other.ownerId != null : !this.ownerId.equals(other.ownerId)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.requesterId == null ? other.requesterId != null : !this.requesterId.equals(other.requesterId)) {
            return false;
        }
        return !(this.reservationId == null ? other.reservationId != null : !this.reservationId.equals(other.reservationId));
    }
}

