/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.ec2.domain.IpPermissionImpl;
import org.jclouds.javax.annotation.Nullable;

public class SecurityGroup
implements Comparable<SecurityGroup> {
    private final String region;
    private final String id;
    private final String name;
    private final String ownerId;
    private final String description;
    private final Set<IpPermissionImpl> ipPermissions;

    public SecurityGroup(String region, String id, String name, String ownerId, String description, Set<IpPermissionImpl> ipPermissions) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.id = id;
        this.name = name;
        this.ownerId = ownerId;
        this.description = description;
        this.ipPermissions = ipPermissions;
    }

    public String getRegion() {
        return this.region;
    }

    @Override
    public int compareTo(SecurityGroup o) {
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<IpPermissionImpl> getIpPermissions() {
        return this.ipPermissions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ipPermissions == null ? 0 : ((Object)this.ipPermissions).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ownerId == null ? 0 : this.ownerId.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityGroup other = (SecurityGroup)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.ipPermissions == null ? other.ipPermissions != null : !((Object)this.ipPermissions).equals(other.ipPermissions)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.ownerId == null ? other.ownerId != null : !this.ownerId.equals(other.ownerId)) {
            return false;
        }
        return !(this.region == null ? other.region != null : !this.region.equals(other.region));
    }

    public String toString() {
        return "[region=" + this.region + ", id=" + this.id + ", name=" + this.name + ", ownerId=" + this.ownerId + ", description=" + this.description + ", ipPermissions=" + this.ipPermissions + "]";
    }
}

