/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import javax.inject.Named;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class BundleInstanceS3StorageOptions
extends BaseEC2RequestOptions {
    @Inject(optional=true)
    @Named(value="jclouds.identity")
    String currentAwsAccessKeyId;

    public Multimap<String, String> buildFormParameters() {
        if (this.getAwsAccessKeyId() == null) {
            Preconditions.checkState((this.currentAwsAccessKeyId != null ? 1 : 0) != 0, (Object)"currentAwsAccessKeyId should have been injected");
            this.bucketOwnedBy(this.currentAwsAccessKeyId);
        }
        return super.buildFormParameters();
    }

    public BundleInstanceS3StorageOptions bucketOwnedBy(String ccessKeyId) {
        this.formParameters.put((Object)"Storage.S3.AWSAccessKeyId", Preconditions.checkNotNull((Object)ccessKeyId, (Object)"ccessKeyId"));
        return this;
    }

    public String getAwsAccessKeyId() {
        return this.getFirstFormOrNull("Storage.S3.AWSAccessKeyId");
    }

    public static class Builder {
        public static BundleInstanceS3StorageOptions bucketOwnedBy(String ccessKeyId) {
            BundleInstanceS3StorageOptions options = new BundleInstanceS3StorageOptions();
            return options.bucketOwnedBy(ccessKeyId);
        }
    }
}

