/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Sets;
import com.google.inject.Provider;
import java.util.Date;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public abstract class BaseReservationHandler<T>
extends ParseSax.HandlerForGeneratedRequestWithResult<T> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final DateService dateService;
    protected final String defaultRegion;
    protected final Provider<RunningInstance.Builder> builderProvider;
    protected StringBuilder currentText = new StringBuilder();
    protected RunningInstance.Builder builder;
    protected int itemDepth;
    boolean inInstancesSet;
    private String volumeId;
    private Attachment.Status attachmentStatus;
    private Date attachTime;
    private boolean deleteOnTermination;
    private String deviceName;
    private Set<String> groupIds = Sets.newLinkedHashSet();
    private String ownerId;
    private String requesterId;
    private String reservationId;
    private Set<RunningInstance> instances = Sets.newLinkedHashSet();

    @Inject
    public BaseReservationHandler(DateService dateService, @Region String defaultRegion, Provider<RunningInstance.Builder> builderProvider) {
        this.dateService = dateService;
        this.defaultRegion = defaultRegion;
        this.builderProvider = builderProvider;
        this.builder = (RunningInstance.Builder)builderProvider.get();
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            ++this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instancesSet")) {
            this.inInstancesSet = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            this.inItem();
            --this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instancesSet")) {
            this.inInstancesSet = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupId")) {
            this.groupIds.add(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ownerId")) {
            this.ownerId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"requesterId")) {
            this.requesterId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"reservationId")) {
            this.reservationId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"amiLaunchIndex")) {
            this.builder.amiLaunchIndex(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"dnsName")) {
            String dnsName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (!"0.0.0.0".equals(dnsName)) {
                this.builder.dnsName(dnsName);
            }
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"imageId")) {
            this.builder.imageId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instanceId")) {
            this.builder.instanceId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"name")) {
            this.builder.instanceState(InstanceState.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instanceType")) {
            this.builder.instanceType(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipAddress")) {
            this.builder.ipAddress(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"kernelId")) {
            this.builder.kernelId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"keyName")) {
            this.builder.keyName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"launchTime")) {
            this.builder.launchTime(this.parseDate());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"availabilityZone")) {
            this.builder.availabilityZone(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"virtualizationType")) {
            this.builder.virtualizationType(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"platform")) {
            this.builder.platform(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"privateDnsName")) {
            String privateDnsName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (!"0.0.0.0".equals(privateDnsName)) {
                this.builder.privateDnsName(privateDnsName);
            }
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"privateIpAddress")) {
            this.builder.privateIpAddress(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ramdiskId")) {
            this.builder.ramdiskId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"reason")) {
            this.builder.reason(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"rootDeviceType")) {
            this.builder.rootDeviceType(RootDeviceType.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"rootDeviceName")) {
            this.builder.rootDeviceName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"deviceName")) {
            this.deviceName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"volumeId")) {
            this.volumeId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"status")) {
            this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"attachTime")) {
            this.attachTime = this.dateService.iso8601DateParse(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"deleteOnTermination")) {
            this.deleteOnTermination = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ebs")) {
            this.builder.device(this.deviceName, new BlockDevice(this.volumeId, this.attachmentStatus, this.attachTime, this.deleteOnTermination));
            this.deviceName = null;
            this.volumeId = null;
            this.attachmentStatus = null;
            this.attachTime = null;
            this.deleteOnTermination = true;
        }
        this.currentText = new StringBuilder();
    }

    protected Date parseDate() {
        try {
            return this.dateService.iso8601DateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
        catch (RuntimeException e) {
            return this.dateService.iso8601SecondsDateParse(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        }
    }

    protected void inItem() {
        if (this.endOfInstanceItem()) {
            this.refineBuilderBeforeAddingInstance();
            this.instances.add(this.builder.build());
            this.builder = (RunningInstance.Builder)this.builderProvider.get();
        }
    }

    protected void refineBuilderBeforeAddingInstance() {
        String region;
        String string = region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest()) : null;
        if (this.builder.getIpAddress() == null && this.builder.getDnsName() != null && this.builder.getDnsName().matches(".*[0-9]$")) {
            this.builder.ipAddress(this.builder.getDnsName());
            this.builder.dnsName(null);
        }
        if (this.builder.getPrivateIpAddress() == null && this.builder.getPrivateDnsName() != null && this.builder.getPrivateDnsName().matches(".*[0-9]$")) {
            this.builder.privateIpAddress(this.builder.getPrivateDnsName());
            this.builder.privateDnsName(null);
        }
        this.builder.region(region == null ? this.defaultRegion : region);
        this.builder.groupIds(this.groupIds);
    }

    protected RunningInstance.Builder builder() {
        return this.builder;
    }

    protected boolean endOfInstanceItem() {
        return this.itemDepth <= 2 && this.inInstancesSet;
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected Reservation<? extends RunningInstance> newReservation() {
        String region;
        String string = region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest()) : null;
        if (region == null) {
            region = this.defaultRegion;
        }
        Reservation<RunningInstance> info = new Reservation<RunningInstance>(region, this.groupIds, this.instances, this.ownerId, this.requesterId, this.reservationId);
        this.groupIds = Sets.newLinkedHashSet();
        this.instances = Sets.newLinkedHashSet();
        this.ownerId = null;
        this.requesterId = null;
        this.reservationId = null;
        return info;
    }
}

