/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.domain.IpPermissionImpl;
import org.jclouds.ec2.domain.IpProtocol;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DescribeSecurityGroupsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<SecurityGroup>> {
    @Inject
    @Region
    String defaultRegion;
    private StringBuilder currentText = new StringBuilder();
    private Set<SecurityGroup> securtyGroups = Sets.newLinkedHashSet();
    private String groupId;
    private String groupName;
    private String ownerId;
    private String groupDescription;
    private Set<IpPermissionImpl> ipPermissions = Sets.newLinkedHashSet();
    private int fromPort;
    private int toPort;
    private Multimap<String, String> groups = LinkedHashMultimap.create();
    private String userId;
    private String userIdGroupName;
    private IpProtocol ipProtocol;
    private Set<String> ipRanges = Sets.newLinkedHashSet();
    private boolean inIpPermissions;
    private boolean inIpRanges;
    private boolean inGroups;

    public Set<SecurityGroup> getResult() {
        return this.securtyGroups;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipPermissions")) {
            this.inIpPermissions = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipRanges")) {
            this.inIpRanges = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groups")) {
            this.inGroups = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupName")) {
            if (!this.inGroups) {
                this.groupName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else {
                this.userIdGroupName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            }
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupId")) {
            this.groupId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ownerId")) {
            this.ownerId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"userId")) {
            this.userId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupDescription")) {
            this.groupDescription = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipProtocol")) {
            this.ipProtocol = IpProtocol.fromValue(SaxUtils.currentOrNegative((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"fromPort")) {
            this.fromPort = Integer.parseInt(SaxUtils.currentOrNegative((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"toPort")) {
            this.toPort = Integer.parseInt(SaxUtils.currentOrNegative((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"cidrIp")) {
            this.ipRanges.add(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipPermissions")) {
            this.inIpPermissions = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipRanges")) {
            this.inIpRanges = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groups")) {
            this.inGroups = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            if (this.inIpPermissions && !this.inIpRanges && !this.inGroups) {
                this.ipPermissions.add(new IpPermissionImpl(this.ipProtocol, this.fromPort, this.toPort, this.groups, (Iterable<String>)ImmutableSet.of(), this.ipRanges));
                this.fromPort = -1;
                this.toPort = -1;
                this.groups = LinkedHashMultimap.create();
                this.ipProtocol = null;
                this.ipRanges = Sets.newLinkedHashSet();
            } else if (this.inIpPermissions && !this.inIpRanges && this.inGroups) {
                this.groups.put((Object)this.userId, (Object)this.userIdGroupName);
                this.userId = null;
                this.userIdGroupName = null;
            } else if (!(this.inIpPermissions || this.inIpRanges || this.inGroups)) {
                String region = AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest());
                if (region == null) {
                    region = this.defaultRegion;
                }
                this.securtyGroups.add(new SecurityGroup(region, this.groupId, this.groupName, this.ownerId, this.groupDescription, this.ipPermissions));
                this.groupName = null;
                this.groupId = null;
                this.ownerId = null;
                this.groupDescription = null;
                this.ipPermissions = Sets.newLinkedHashSet();
            }
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

