/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public interface ComputeServiceAdapter<N, H, I, L> {
    public NodeAndInitialCredentials<N> createNodeWithGroupEncodedIntoName(String var1, String var2, Template var3);

    public Iterable<H> listHardwareProfiles();

    public Iterable<I> listImages();

    public Iterable<L> listLocations();

    public N getNode(String var1);

    public void destroyNode(String var1);

    public void rebootNode(String var1);

    public void resumeNode(String var1);

    public void suspendNode(String var1);

    public Iterable<N> listNodes();

    public static class NodeAndInitialCredentials<N> {
        private final N node;
        private final String nodeId;
        private final LoginCredentials credentials;

        public NodeAndInitialCredentials(N node, String nodeId, @Nullable LoginCredentials credentials) {
            this.node = Preconditions.checkNotNull(node, (Object)"node");
            this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId");
            this.credentials = credentials;
        }

        public N getNode() {
            return this.node;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        @Nullable
        public LoginCredentials getCredentials() {
            return this.credentials;
        }
    }
}

