/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collections;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.callables.InitScriptConfigurationForTasks;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.callables.SudoAwareInitManager;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.InitBuilder;
import org.jclouds.scriptbuilder.domain.AdminAccessVisitor;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementVisitor;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.SshException;

public class RunScriptOnNodeAsInitScriptUsingSsh
extends SudoAwareInitManager
implements RunScriptOnNode {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final String initFile;

    public String getInitFile() {
        return this.initFile;
    }

    @AssistedInject
    public RunScriptOnNodeAsInitScriptUsingSsh(Function<NodeMetadata, SshClient> sshFactory, InitScriptConfigurationForTasks initScriptConfiguration, @Assisted NodeMetadata node, @Assisted Statement script, @Assisted RunScriptOptions options) {
        super(sshFactory, options.shouldRunAsRoot(), (NodeMetadata)Preconditions.checkNotNull((Object)node, (Object)"node"), Preconditions.checkNotNull((Object)script, (Object)"script") instanceof InitBuilder ? (InitBuilder)InitBuilder.class.cast(script) : RunScriptOnNodeAsInitScriptUsingSsh.createInitScript((InitScriptConfigurationForTasks)Preconditions.checkNotNull((Object)initScriptConfiguration, (Object)"initScriptConfiguration"), options.getTaskName(), script));
        this.initFile = String.format(initScriptConfiguration.getInitScriptPattern(), this.init.getInstanceName());
    }

    @Override
    public RunScriptOnNodeAsInitScriptUsingSsh init() {
        super.init();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecResponse call() {
        Preconditions.checkState((this.ssh != null ? 1 : 0) != 0, (Object)"please call init() before invoking call");
        try {
            this.ssh.connect();
            ExecResponse execResponse = this.doCall();
            return execResponse;
        }
        finally {
            if (this.ssh != null) {
                this.ssh.disconnect();
            }
        }
    }

    public static InitBuilder createInitScript(InitScriptConfigurationForTasks config, String name, Statement script) {
        if (name == null) {
            name = "jclouds-script-" + (String)config.getAnonymousTaskSuffixSupplier().get();
        }
        return new InitBuilder(name, config.getBasedir() + "/" + name, config.getBasedir() + "/" + name, Collections.emptyMap(), Collections.singleton(script));
    }

    protected void refreshSshIfNewAdminCredentialsConfigured(AdminAccess input) {
        if (input.getAdminCredentials() != null && input.shouldGrantSudoToAdminUser()) {
            this.ssh.disconnect();
            this.logger.debug(">> reconnecting as %s@%s", new Object[]{input.getAdminCredentials().identity, this.ssh.getHostAddress()});
            this.node = NodeMetadataBuilder.fromNodeMetadata(this.node).credentials(LoginCredentials.fromCredentials((Credentials)input.getAdminCredentials())).build();
            this.ssh = (SshClient)this.sshFactory.apply((Object)this.node);
            this.ssh.connect();
            this.setupLinkToInitFile();
        }
    }

    protected ExecResponse doCall() {
        try {
            this.ssh.put(this.initFile, this.init.render(OsFamily.UNIX));
        }
        catch (SshException e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.warn((Throwable)e, "<< (%s) problem using sftp [%s], attempting via sshexec", new Object[]{this.ssh.toString(), e.getMessage()});
            } else {
                this.logger.warn("<< (%s) problem using sftp [%s], attempting via sshexec", new Object[]{this.ssh.toString(), e.getMessage()});
            }
            this.ssh.disconnect();
            this.ssh.connect();
            this.ssh.exec("rm " + this.initFile);
            this.ssh.exec(Statements.appendFile((String)this.initFile, (Iterable)Splitter.on((char)'\n').split((CharSequence)this.init.render(OsFamily.UNIX)), (String)("END_OF_FILE_" + this.init.getInstanceName())).render(OsFamily.UNIX));
        }
        this.ssh.exec("chmod 755 " + this.initFile);
        this.setupLinkToInitFile();
        this.runAction("init");
        this.init.getInitStatement().accept((StatementVisitor)new AdminAccessVisitor(){

            public void visit(AdminAccess input) {
                RunScriptOnNodeAsInitScriptUsingSsh.this.refreshSshIfNewAdminCredentialsConfigured(input);
            }
        });
        return this.runAction("start");
    }

    protected void setupLinkToInitFile() {
        this.ssh.exec(String.format("ln -fs %s %s", this.initFile, this.init.getInstanceName()));
    }
}

