/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.collect.ComparisonChain;

public class Processor
implements Comparable<Processor> {
    private final double cores;
    private final double speed;

    public Processor(double cores, double speed) {
        this.cores = cores;
        this.speed = speed;
    }

    @Override
    public int compareTo(Processor that) {
        if (that instanceof Processor) {
            Processor thatProcessor = (Processor)Processor.class.cast(that);
            return ComparisonChain.start().compare(this.getCores(), thatProcessor.getCores()).compare(this.getSpeed(), thatProcessor.getSpeed()).result();
        }
        return -1;
    }

    public double getCores() {
        return this.cores;
    }

    public double getSpeed() {
        return this.speed;
    }

    public String toString() {
        return "[cores=" + this.cores + ", speed=" + this.speed + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.cores);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.speed);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Processor other = (Processor)obj;
        if (Double.doubleToLongBits(this.cores) != Double.doubleToLongBits(other.cores)) {
            return false;
        }
        return Double.doubleToLongBits(this.speed) == Double.doubleToLongBits(other.speed);
    }
}

