/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadata;
import org.jclouds.javax.annotation.Nullable;

public class HardwareImpl
extends ComputeMetadataImpl
implements Hardware {
    private static final long serialVersionUID = 8994255275911717567L;
    private final List<Processor> processors;
    private final int ram;
    private final List<Volume> volumes;
    private final Predicate<Image> supportsImage;

    public HardwareImpl(String providerId, String name, String id, @Nullable Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, Iterable<? extends Processor> processors, int ram, Iterable<? extends Volume> volumes, Predicate<Image> supportsImage) {
        super(ComputeType.HARDWARE, providerId, name, id, location, uri, userMetadata, tags);
        this.processors = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(processors, (Object)"processors")));
        this.ram = ram;
        this.volumes = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(volumes, (Object)"volumes")));
        this.supportsImage = supportsImage;
    }

    @Override
    public List<? extends Processor> getProcessors() {
        return this.processors;
    }

    @Override
    public int getRam() {
        return this.ram;
    }

    @Override
    public List<? extends Volume> getVolumes() {
        return this.volumes;
    }

    public int compareTo(ResourceMetadata<ComputeType> that) {
        if (that instanceof Hardware) {
            Hardware thatHardware = (Hardware)Hardware.class.cast(that);
            return ComparisonChain.start().compare(ComputeServiceUtils.getCoresAndSpeed(this), ComputeServiceUtils.getCoresAndSpeed(thatHardware)).compare(this.getRam(), thatHardware.getRam()).compare(ComputeServiceUtils.getSpace(this), ComputeServiceUtils.getSpace(thatHardware)).result();
        }
        return super.compareTo(that);
    }

    public String toString() {
        return "[id=" + this.getId() + ", providerId=" + this.getProviderId() + ", name=" + this.getName() + ", processors=" + this.processors + ", ram=" + this.ram + ", volumes=" + this.volumes + ", supportsImage=" + this.supportsImage + ", tags=" + this.tags + "]";
    }

    @Override
    public Predicate<Image> supportsImage() {
        return this.supportsImage;
    }
}

