/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public class ImageImpl
extends ComputeMetadataImpl
implements Image {
    private static final long serialVersionUID = 7856744554191025307L;
    private final OperatingSystem operatingSystem;
    private final String version;
    private final String description;
    private final LoginCredentials defaultCredentials;

    @Deprecated
    public ImageImpl(String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, OperatingSystem operatingSystem, String description, @Nullable String version, @Nullable String adminPassword, @Nullable Credentials defaultCredentials) {
        super(ComputeType.IMAGE, providerId, name, id, location, uri, userMetadata, tags);
        this.operatingSystem = (OperatingSystem)Preconditions.checkNotNull((Object)operatingSystem, (Object)"operatingSystem");
        this.version = version;
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        LoginCredentials.Builder builder = LoginCredentials.builder((Credentials)defaultCredentials);
        if (adminPassword != null) {
            builder.authenticateSudo(true);
            builder.password(adminPassword);
        }
        this.defaultCredentials = builder.build();
    }

    public ImageImpl(String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Set<String> tags, OperatingSystem operatingSystem, String description, @Nullable String version, @Nullable LoginCredentials defaultCredentials) {
        super(ComputeType.IMAGE, providerId, name, id, location, uri, userMetadata, tags);
        this.operatingSystem = (OperatingSystem)Preconditions.checkNotNull((Object)operatingSystem, (Object)"operatingSystem");
        this.version = version;
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.defaultCredentials = defaultCredentials;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LoginCredentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    @Override
    @Deprecated
    public String getAdminPassword() {
        return this.defaultCredentials != null && this.defaultCredentials.shouldAuthenticateSudo() ? this.defaultCredentials.getPassword() : null;
    }

    public String toString() {
        return "[id=" + this.getId() + ", name=" + this.getName() + ", operatingSystem=" + this.operatingSystem + ", description=" + this.description + ", version=" + this.version + ", location=" + this.getLocation() + ", loginUser=" + (this.defaultCredentials != null ? this.defaultCredentials.identity : null) + ", userMetadata=" + this.getUserMetadata() + ", tags=" + this.tags + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.defaultCredentials == null ? 0 : this.defaultCredentials.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.operatingSystem == null ? 0 : this.operatingSystem.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageImpl other = (ImageImpl)obj;
        if (this.defaultCredentials == null ? other.defaultCredentials != null : !this.defaultCredentials.equals((Object)other.defaultCredentials)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.operatingSystem == null ? other.operatingSystem != null : !this.operatingSystem.equals(other.operatingSystem)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

