/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.TemplateImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.util.Lists2;

public class TemplateBuilderImpl
implements TemplateBuilder {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final Supplier<Set<? extends Location>> locations;
    protected final Supplier<Location> defaultLocation;
    protected final Provider<TemplateOptions> optionsProvider;
    protected final Provider<TemplateBuilder> defaultTemplateProvider;
    @VisibleForTesting
    protected Location location;
    @VisibleForTesting
    protected String imageId;
    @VisibleForTesting
    protected String hardwareId;
    @VisibleForTesting
    protected String imageVersion;
    @VisibleForTesting
    protected OsFamily osFamily;
    @VisibleForTesting
    protected String osVersion;
    @VisibleForTesting
    protected Boolean os64Bit;
    @VisibleForTesting
    protected String osName;
    @VisibleForTesting
    protected String osDescription;
    @VisibleForTesting
    protected String osArch;
    @VisibleForTesting
    protected String imageName;
    @VisibleForTesting
    protected String imageDescription;
    @VisibleForTesting
    protected Predicate<Image> imagePredicate;
    @VisibleForTesting
    protected double minCores;
    @VisibleForTesting
    protected int minRam;
    @VisibleForTesting
    protected boolean biggest;
    @VisibleForTesting
    protected boolean fastest;
    @VisibleForTesting
    protected TemplateOptions options;
    final Predicate<ComputeMetadata> locationPredicate = new Predicate<ComputeMetadata>(){

        public boolean apply(ComputeMetadata input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.location != null && input.getLocation() != null) {
                returnVal = TemplateBuilderImpl.this.location.equals(input.getLocation()) || TemplateBuilderImpl.this.location.getParent() != null && TemplateBuilderImpl.this.location.getParent().equals(input.getLocation()) || TemplateBuilderImpl.this.location.getParent().getParent() != null && TemplateBuilderImpl.this.location.getParent().getParent().equals(input.getLocation());
            }
            return returnVal;
        }

        public String toString() {
            return TemplateBuilderImpl.this.location == null ? "anyLocation()" : "locationEqualsOrChildOf(" + TemplateBuilderImpl.this.location.getId() + ")";
        }
    };
    private final Predicate<Image> idPredicate = new Predicate<Image>(){

        public boolean apply(Image input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.imageId != null && (returnVal = TemplateBuilderImpl.this.imageId.equals(input.getId()))) {
                TemplateBuilderImpl.this.fromImage(input);
            }
            return returnVal;
        }

        public String toString() {
            return "imageId(" + TemplateBuilderImpl.this.imageId + ")";
        }
    };
    private final Predicate<OperatingSystem> osFamilyPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osFamily != null) {
                returnVal = TemplateBuilderImpl.this.osFamily.equals((Object)input.getFamily());
            }
            return returnVal;
        }

        public String toString() {
            return "osFamily(" + (Object)((Object)TemplateBuilderImpl.this.osFamily) + ")";
        }
    };
    private final Predicate<OperatingSystem> osNamePredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osName != null) {
                returnVal = input.getName() == null ? false : input.getName().contains(TemplateBuilderImpl.this.osName) || input.getName().matches(TemplateBuilderImpl.this.osName);
            }
            return returnVal;
        }

        public String toString() {
            return "osName(" + TemplateBuilderImpl.this.osName + ")";
        }
    };
    private final Predicate<OperatingSystem> osDescriptionPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osDescription != null) {
                returnVal = input.getDescription() == null ? false : input.getDescription().contains(TemplateBuilderImpl.this.osDescription) || input.getDescription().matches(TemplateBuilderImpl.this.osDescription);
            }
            return returnVal;
        }

        public String toString() {
            return "osDescription(" + TemplateBuilderImpl.this.osDescription + ")";
        }
    };
    private final Predicate<OperatingSystem> osVersionPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osVersion != null) {
                returnVal = input.getVersion() == null ? false : input.getVersion().contains(TemplateBuilderImpl.this.osVersion) || input.getVersion().matches(TemplateBuilderImpl.this.osVersion);
            }
            return returnVal;
        }

        public String toString() {
            return "osVersion(" + TemplateBuilderImpl.this.osVersion + ")";
        }
    };
    private final Predicate<OperatingSystem> os64BitPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.os64Bit != null) {
                if (TemplateBuilderImpl.this.os64Bit.booleanValue()) {
                    return input.is64Bit();
                }
                return !input.is64Bit();
            }
            return returnVal;
        }

        public String toString() {
            return "os64Bit(" + TemplateBuilderImpl.this.os64Bit + ")";
        }
    };
    private final Predicate<OperatingSystem> osArchPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osArch != null) {
                returnVal = input.getArch() == null ? false : input.getArch().contains(TemplateBuilderImpl.this.osArch) || input.getArch().matches(TemplateBuilderImpl.this.osArch);
            }
            return returnVal;
        }

        public String toString() {
            return "osArch(" + TemplateBuilderImpl.this.osArch + ")";
        }
    };
    private final Predicate<Image> imageVersionPredicate = new Predicate<Image>(){

        public boolean apply(Image input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.imageVersion != null) {
                returnVal = input.getVersion() == null ? false : input.getVersion().contains(TemplateBuilderImpl.this.imageVersion) || input.getVersion().matches(TemplateBuilderImpl.this.imageVersion);
            }
            return returnVal;
        }

        public String toString() {
            return "imageVersion(" + TemplateBuilderImpl.this.imageVersion + ")";
        }
    };
    private final Predicate<Image> imageNamePredicate = new Predicate<Image>(){

        public boolean apply(Image input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.imageName != null) {
                returnVal = input.getName() == null ? false : input.getName().equals(TemplateBuilderImpl.this.imageName) || input.getName().contains(TemplateBuilderImpl.this.imageName) || input.getName().matches(TemplateBuilderImpl.this.imageName);
            }
            return returnVal;
        }

        public String toString() {
            return "imageName(" + TemplateBuilderImpl.this.imageName + ")";
        }
    };
    private final Predicate<Image> imageDescriptionPredicate = new Predicate<Image>(){

        public boolean apply(Image input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.imageDescription != null) {
                returnVal = input.getDescription() == null ? false : input.getDescription().equals(TemplateBuilderImpl.this.imageDescription) || input.getDescription().contains(TemplateBuilderImpl.this.imageDescription) || input.getDescription().matches(TemplateBuilderImpl.this.imageDescription);
            }
            return returnVal;
        }

        public String toString() {
            return "imageDescription(" + TemplateBuilderImpl.this.imageDescription + ")";
        }
    };
    private final Predicate<Hardware> hardwareIdPredicate = new Predicate<Hardware>(){

        public boolean apply(Hardware input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.hardwareId != null) {
                returnVal = TemplateBuilderImpl.this.hardwareId.equals(input.getId());
            }
            return returnVal;
        }

        public String toString() {
            return "hardwareId(" + TemplateBuilderImpl.this.hardwareId + ")";
        }
    };
    private final Predicate<Hardware> hardwareCoresPredicate = new Predicate<Hardware>(){

        public boolean apply(Hardware input) {
            double cores = ComputeServiceUtils.getCores(input);
            return cores >= TemplateBuilderImpl.this.minCores;
        }

        public String toString() {
            return "minCores(" + TemplateBuilderImpl.this.minCores + ")";
        }
    };
    private final Predicate<Hardware> hardwareRamPredicate = new Predicate<Hardware>(){

        public boolean apply(Hardware input) {
            return input.getRam() >= TemplateBuilderImpl.this.minRam;
        }

        public String toString() {
            return "minRam(" + TemplateBuilderImpl.this.minRam + ")";
        }
    };
    static final Ordering<Hardware> DEFAULT_SIZE_ORDERING = new Ordering<Hardware>(){

        public int compare(Hardware left, Hardware right) {
            return ComparisonChain.start().compare(ComputeServiceUtils.getCores(left), ComputeServiceUtils.getCores(right)).compare(left.getRam(), right.getRam()).compare(ComputeServiceUtils.getSpace(left), ComputeServiceUtils.getSpace(right)).result();
        }
    };
    static final Ordering<Hardware> BY_CORES_ORDERING = new Ordering<Hardware>(){

        public int compare(Hardware left, Hardware right) {
            return Doubles.compare((double)ComputeServiceUtils.getCoresAndSpeed(left), (double)ComputeServiceUtils.getCoresAndSpeed(right));
        }
    };
    static final Ordering<Image> DEFAULT_IMAGE_ORDERING = new Ordering<Image>(){

        public int compare(Image left, Image right) {
            return ComparisonChain.start().compare((Object)left.getName(), (Object)right.getName(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getVersion(), (Object)right.getVersion(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getDescription(), (Object)right.getDescription(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getOperatingSystem().getName(), (Object)right.getOperatingSystem().getName(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getOperatingSystem().getVersion(), (Object)right.getOperatingSystem().getVersion(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getOperatingSystem().getDescription(), (Object)right.getOperatingSystem().getDescription(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getOperatingSystem().getArch(), (Object)right.getOperatingSystem().getArch(), (Comparator)Ordering.natural().nullsLast()).result();
        }
    };
    private static final Function<Image, String> imageToId = new Function<Image, String>(){

        public String apply(Image arg0) {
            return arg0.getId();
        }
    };
    private static final Function<Hardware, String> hardwareToId = new Function<Hardware, String>(){

        public String apply(Hardware arg0) {
            return arg0.getId();
        }
    };

    @Inject
    protected TemplateBuilderImpl(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, Supplier<Location> defaultLocation2, @Named(value="DEFAULT") Provider<TemplateOptions> optionsProvider, @Named(value="DEFAULT") Provider<TemplateBuilder> defaultTemplateProvider) {
        this.locations = locations;
        this.images = images;
        this.hardwares = hardwares;
        this.defaultLocation = defaultLocation2;
        this.optionsProvider = optionsProvider;
        this.defaultTemplateProvider = defaultTemplateProvider;
    }

    private Predicate<Hardware> buildHardwarePredicate() {
        ArrayList predicates = Lists.newArrayList();
        if (this.hardwareId != null) {
            predicates.add(this.hardwareIdPredicate);
        } else {
            if (this.location != null) {
                predicates.add(new Predicate<Hardware>(){

                    public boolean apply(Hardware input) {
                        return TemplateBuilderImpl.this.locationPredicate.apply((Object)input);
                    }

                    public String toString() {
                        return TemplateBuilderImpl.this.locationPredicate.toString();
                    }
                });
            }
            predicates.add(this.hardwareCoresPredicate);
            predicates.add(this.hardwareRamPredicate);
        }
        Predicate hardwarePredicate = predicates.size() == 1 ? (Predicate)Iterables.get((Iterable)predicates, (int)0) : Predicates.and((Iterable)predicates);
        return hardwarePredicate;
    }

    @Override
    public TemplateBuilder fromTemplate(Template template) {
        this.location = template.getLocation();
        this.fromHardware(template.getHardware());
        this.fromImage(template.getImage());
        this.options(template.getOptions());
        return this;
    }

    @Override
    public TemplateBuilder fromHardware(Hardware hardware) {
        if (this.currentLocationWiderThan(hardware.getLocation())) {
            this.location = hardware.getLocation();
        }
        this.minCores = ComputeServiceUtils.getCores(hardware);
        this.minRam = hardware.getRam();
        return this;
    }

    private boolean currentLocationWiderThan(Location location) {
        return this.location == null || location != null && this.location.getScope().compareTo((Enum)location.getScope()) < 0;
    }

    @Override
    public TemplateBuilder fromImage(Image image) {
        if (this.currentLocationWiderThan(image.getLocation())) {
            this.location = image.getLocation();
        }
        if (image.getOperatingSystem().getFamily() != null) {
            this.osFamily = image.getOperatingSystem().getFamily();
        }
        if (image.getName() != null) {
            this.imageName = image.getName();
        }
        if (image.getDescription() != null) {
            this.imageDescription = image.getDescription();
        }
        if (image.getOperatingSystem().getName() != null) {
            this.osName = image.getOperatingSystem().getName();
        }
        if (image.getOperatingSystem().getDescription() != null) {
            this.osDescription = image.getOperatingSystem().getDescription();
        }
        if (image.getVersion() != null) {
            this.imageVersion = image.getVersion();
        }
        if (image.getOperatingSystem().getVersion() != null) {
            this.osVersion = image.getOperatingSystem().getVersion();
        }
        this.os64Bit = image.getOperatingSystem().is64Bit();
        if (image.getOperatingSystem().getArch() != null) {
            this.osArch = image.getOperatingSystem().getArch();
        }
        return this;
    }

    @Override
    public TemplateBuilder smallest() {
        this.biggest = false;
        return this;
    }

    @Override
    public TemplateBuilder biggest() {
        this.biggest = true;
        return this;
    }

    @Override
    public TemplateBuilder fastest() {
        this.fastest = true;
        return this;
    }

    @Override
    public TemplateBuilder locationId(final String locationId) {
        Set locations = (Set)this.locations.get();
        try {
            this.location = (Location)Iterables.find((Iterable)locations, (Predicate)new Predicate<Location>(){

                public boolean apply(Location input) {
                    return input.getId().equals(locationId);
                }

                public String toString() {
                    return "locationId(" + locationId + ")";
                }
            });
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("location id %s not found in: %s", locationId, locations));
        }
        return this;
    }

    @Override
    public TemplateBuilder osFamily(OsFamily os) {
        this.osFamily = os;
        return this;
    }

    @Override
    public Template build() {
        if (this.nothingChangedExceptOptions()) {
            TemplateBuilder defaultTemplate = (TemplateBuilder)this.defaultTemplateProvider.get();
            if (this.options != null) {
                defaultTemplate.options(this.options);
            }
            return defaultTemplate.build();
        }
        if (this.options == null) {
            this.options = (TemplateOptions)this.optionsProvider.get();
        }
        this.logger.debug(">> searching params(%s)", new Object[]{this});
        Set<? extends Image> images = this.getImages();
        if (this.location == null) {
            this.location = (Location)this.defaultLocation.get();
        }
        Predicate<Image> imagePredicate = this.buildImagePredicate();
        Iterable supportedImages = Iterables.filter(images, this.buildImagePredicate());
        if (Iterables.size((Iterable)supportedImages) == 0) {
            if (imagePredicate == this.idPredicate) {
                throw new NoSuchElementException(String.format("%s not found", this.idPredicate));
            }
            this.throwNoSuchElementExceptionAfterLoggingImageIds(String.format("no image matched predicate: %s", imagePredicate), images);
        }
        Hardware hardware = this.resolveHardware(this.hardwareSorter(), supportedImages);
        Image image = this.resolveImage(hardware, supportedImages);
        this.logger.debug("<<   matched image(%s)", new Object[]{image.getId()});
        return new TemplateImpl(image, hardware, this.location, this.options);
    }

    protected void throwNoSuchElementExceptionAfterLoggingImageIds(String message, Iterable<? extends Image> images) {
        NoSuchElementException exception = new NoSuchElementException(message);
        if (this.logger.isTraceEnabled()) {
            this.logger.warn((Throwable)exception, "image ids that didn't match: %s", new Object[]{Iterables.transform(images, imageToId)});
        }
        throw exception;
    }

    protected Hardware resolveHardware(Ordering<Hardware> hardwareOrdering, final Iterable<? extends Image> images) {
        Hardware hardware;
        Set hardwarel = (Set)this.hardwares.get();
        Object hardwaresThatAreCompatibleWithOurImages = ImmutableSet.of();
        try {
            hardwaresThatAreCompatibleWithOurImages = Iterables.filter((Iterable)hardwarel, (Predicate)new Predicate<Hardware>(){

                public boolean apply(final Hardware hardware) {
                    return Iterables.any((Iterable)images, (Predicate)new Predicate<Image>(){

                        public boolean apply(Image input) {
                            return hardware.supportsImage().apply((Object)input);
                        }

                        public String toString() {
                            return "hardware(" + hardware + ").supportsImage()";
                        }
                    });
                }
            });
        }
        catch (NoSuchElementException exception) {
            // empty catch block
        }
        if (Iterables.size((Iterable)hardwaresThatAreCompatibleWithOurImages) == 0) {
            String message = String.format("no hardware profiles support images matching params: %s", this.toString());
            NoSuchElementException exception = new NoSuchElementException(message);
            if (this.logger.isTraceEnabled()) {
                this.logger.warn((Throwable)exception, "hardware profiles %s\nimage ids %s", new Object[]{Iterables.transform((Iterable)hardwarel, hardwareToId), Iterables.transform(images, imageToId)});
            }
            throw exception;
        }
        Predicate<Hardware> hardwarePredicate = this.buildHardwarePredicate();
        try {
            hardware = (Hardware)hardwareOrdering.max(Iterables.filter((Iterable)hardwaresThatAreCompatibleWithOurImages, hardwarePredicate));
        }
        catch (NoSuchElementException exception) {
            String message = String.format("no hardware profiles match params: %s", hardwarePredicate);
            exception = new NoSuchElementException(message);
            if (this.logger.isTraceEnabled()) {
                this.logger.warn((Throwable)exception, "hardware profiles %s", new Object[]{Iterables.transform((Iterable)hardwaresThatAreCompatibleWithOurImages, hardwareToId)});
            }
            throw exception;
        }
        this.logger.debug("<<   matched hardware(%s)", new Object[]{hardware.getId()});
        return hardware;
    }

    protected Ordering<Hardware> hardwareSorter() {
        Ordering hardwareOrdering = DEFAULT_SIZE_ORDERING;
        if (!this.biggest) {
            hardwareOrdering = hardwareOrdering.reverse();
        }
        if (this.fastest) {
            hardwareOrdering = Ordering.compound((Iterable)ImmutableList.of(BY_CORES_ORDERING, (Object)hardwareOrdering));
        }
        return hardwareOrdering;
    }

    protected Image resolveImage(final Hardware hardware, Iterable<? extends Image> supportedImages) {
        Predicate<Image> imagePredicate = new Predicate<Image>(){

            public boolean apply(Image arg0) {
                return hardware.supportsImage().apply((Object)arg0);
            }

            public String toString() {
                return "hardware(" + hardware + ").supportsImage()";
            }
        };
        try {
            Iterable matchingImages = Iterables.filter(supportedImages, (Predicate)imagePredicate);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<<   matched images(%s)", new Object[]{Iterables.transform((Iterable)matchingImages, imageToId)});
            }
            List maxImages = Lists2.multiMax(DEFAULT_IMAGE_ORDERING, (Iterable)matchingImages);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<<   best images(%s)", new Object[]{Iterables.transform((Iterable)maxImages, imageToId)});
            }
            return (Image)maxImages.get(maxImages.size() - 1);
        }
        catch (NoSuchElementException exception) {
            this.throwNoSuchElementExceptionAfterLoggingImageIds(String.format("no image matched params: %s", this.toString()), supportedImages);
            assert (false);
            return null;
        }
    }

    protected Set<? extends Image> getImages() {
        return (Set)this.images.get();
    }

    private Predicate<Image> buildImagePredicate() {
        ArrayList predicates = Lists.newArrayList();
        if (this.imageId != null) {
            predicates.add(this.idPredicate);
        } else {
            if (this.location != null) {
                predicates.add(new Predicate<Image>(){

                    public boolean apply(Image input) {
                        return TemplateBuilderImpl.this.locationPredicate.apply((Object)input);
                    }

                    public String toString() {
                        return TemplateBuilderImpl.this.locationPredicate.toString();
                    }
                });
            }
            final ArrayList osPredicates = Lists.newArrayList();
            if (this.osFamily != null) {
                osPredicates.add(this.osFamilyPredicate);
            }
            if (this.osName != null) {
                osPredicates.add(this.osNamePredicate);
            }
            if (this.osDescription != null) {
                osPredicates.add(this.osDescriptionPredicate);
            }
            if (this.osVersion != null) {
                osPredicates.add(this.osVersionPredicate);
            }
            if (this.os64Bit != null) {
                osPredicates.add(this.os64BitPredicate);
            }
            if (this.osArch != null) {
                osPredicates.add(this.osArchPredicate);
            }
            if (osPredicates.size() > 0) {
                predicates.add(new Predicate<Image>(){

                    public boolean apply(Image input) {
                        return Predicates.and((Iterable)osPredicates).apply((Object)input.getOperatingSystem());
                    }

                    public String toString() {
                        return Predicates.and((Iterable)osPredicates).toString();
                    }
                });
            }
            if (this.imageVersion != null) {
                predicates.add(this.imageVersionPredicate);
            }
            if (this.imageName != null) {
                predicates.add(this.imageNamePredicate);
            }
            if (this.imageDescription != null) {
                predicates.add(this.imageDescriptionPredicate);
            }
            if (this.imagePredicate != null) {
                predicates.add(this.imagePredicate);
            }
        }
        Predicate imagePredicate = predicates.size() == 1 ? (Predicate)Iterables.get((Iterable)predicates, (int)0) : Predicates.and((Iterable)predicates);
        return imagePredicate;
    }

    @Override
    public TemplateBuilder imageId(String imageId) {
        this.imageId = imageId;
        this.imageName = null;
        this.imageDescription = null;
        this.imagePredicate = null;
        this.imageVersion = null;
        this.osFamily = null;
        this.osName = null;
        this.osDescription = null;
        this.osVersion = null;
        this.os64Bit = null;
        this.osArch = null;
        return this;
    }

    @Override
    public TemplateBuilder imageNameMatches(String nameRegex) {
        this.imageName = nameRegex;
        return this;
    }

    @Override
    public TemplateBuilder imageDescriptionMatches(String descriptionRegex) {
        this.imageDescription = descriptionRegex;
        return this;
    }

    @Override
    public TemplateBuilder imageMatches(Predicate<Image> condition) {
        this.imagePredicate = condition;
        return this;
    }

    @Override
    public TemplateBuilder imageVersionMatches(String imageVersionRegex) {
        this.imageVersion = imageVersionRegex;
        return this;
    }

    @Override
    public TemplateBuilder osVersionMatches(String osVersionRegex) {
        this.osVersion = osVersionRegex;
        return this;
    }

    @Override
    public TemplateBuilder osArchMatches(String osArchitectureRegex) {
        this.osArch = osArchitectureRegex;
        return this;
    }

    @Override
    public TemplateBuilder minCores(double minCores) {
        this.minCores = minCores;
        return this;
    }

    @Override
    public TemplateBuilder minRam(int megabytes) {
        this.minRam = megabytes;
        return this;
    }

    @Override
    public TemplateBuilder osNameMatches(String osNameRegex) {
        this.osName = osNameRegex;
        return this;
    }

    @Override
    public TemplateBuilder osDescriptionMatches(String osDescriptionRegex) {
        this.osDescription = osDescriptionRegex;
        return this;
    }

    @Override
    public TemplateBuilder hardwareId(String hardwareId) {
        this.hardwareId = hardwareId;
        return this;
    }

    @Override
    public TemplateBuilder options(TemplateOptions options) {
        this.options = (TemplateOptions)this.optionsProvider.get();
        ((TemplateOptions)Preconditions.checkNotNull((Object)options, (Object)"options")).copyTo(this.options);
        return this;
    }

    @VisibleForTesting
    boolean nothingChangedExceptOptions() {
        return this.osFamily == null && this.location == null && this.imageId == null && this.hardwareId == null && this.osName == null && this.imagePredicate == null && this.osDescription == null && this.imageVersion == null && this.osVersion == null && this.osArch == null && this.os64Bit == null && this.imageName == null && this.imageDescription == null && this.minCores == 0.0 && this.minRam == 0 && !this.biggest && !this.fastest;
    }

    @Override
    public TemplateBuilder any() {
        return (TemplateBuilder)this.defaultTemplateProvider.get();
    }

    public String toString() {
        return "[biggest=" + this.biggest + ", fastest=" + this.fastest + ", imageName=" + this.imageName + ", imageDescription=" + this.imageDescription + ", imageId=" + this.imageId + ", imagePredicate=" + this.imagePredicate + ", imageVersion=" + this.imageVersion + ", location=" + this.location + ", minCores=" + this.minCores + ", minRam=" + this.minRam + ", osFamily=" + (Object)((Object)this.osFamily) + ", osName=" + this.osName + ", osDescription=" + this.osDescription + ", osVersion=" + this.osVersion + ", osArch=" + this.osArch + ", os64Bit=" + this.os64Bit + ", hardwareId=" + this.hardwareId + "]";
    }

    @Override
    public TemplateBuilder os64Bit(boolean is64Bit) {
        this.os64Bit = is64Bit;
        return this;
    }
}

