/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.options;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.jclouds.compute.functions.DefaultCredentialsFromImageOrOverridingCredentials;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.CredentialUtils;

public class RunScriptOptions {
    public static final RunScriptOptions NONE = new ImmutableRunScriptOptions(new RunScriptOptions());
    protected int port = -1;
    protected int seconds = -1;
    protected String taskName;
    protected boolean runAsRoot = true;
    protected boolean blockOnComplete = true;
    protected boolean wrapInInitScript = true;
    protected String loginUser;
    protected Boolean authenticateSudo;
    protected Optional<String> loginPassword;
    protected Optional<String> loginPrivateKey;

    @Deprecated
    public RunScriptOptions overrideCredentialsWith(Credentials overridingCredentials) {
        return this.overrideLoginCredentials(LoginCredentials.fromCredentials((Credentials)overridingCredentials));
    }

    public RunScriptOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        Preconditions.checkNotNull((Object)overridingCredentials, (Object)"overridingCredentials");
        this.loginUser = overridingCredentials.getUser();
        this.loginPassword = overridingCredentials.getOptionalPassword();
        this.loginPrivateKey = overridingCredentials.getOptionalPrivateKey();
        this.authenticateSudo = overridingCredentials.shouldAuthenticateSudo() ? Boolean.valueOf(true) : null;
        return this;
    }

    @Deprecated
    public RunScriptOptions overrideLoginUserWith(String loginUser) {
        return this.overrideLoginUser(loginUser);
    }

    public RunScriptOptions overrideLoginUser(String loginUser) {
        Preconditions.checkNotNull((Object)loginUser, (Object)"loginUser");
        this.loginUser = loginUser;
        return this;
    }

    @Deprecated
    public RunScriptOptions overrideLoginCredentialWith(String loginCredential) {
        Preconditions.checkNotNull((Object)loginCredential, (Object)"loginCredential");
        if (CredentialUtils.isPrivateKeyCredential((String)loginCredential)) {
            this.loginPrivateKey = Optional.of((Object)loginCredential);
            this.loginPassword = Optional.absent();
        } else {
            this.loginPrivateKey = Optional.absent();
            this.loginPassword = Optional.of((Object)loginCredential);
        }
        return this;
    }

    public RunScriptOptions overrideLoginPassword(String password) {
        Preconditions.checkNotNull((Object)password, (Object)"password");
        this.loginPassword = Optional.of((Object)password);
        return this;
    }

    public RunScriptOptions overrideLoginPrivateKey(String privateKey) {
        Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey");
        this.loginPrivateKey = Optional.of((Object)privateKey);
        return this;
    }

    public RunScriptOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        this.authenticateSudo = authenticateSudo;
        return this;
    }

    public RunScriptOptions nameTask(String name) {
        this.taskName = name;
        return this;
    }

    public RunScriptOptions runAsRoot(boolean runAsRoot) {
        this.runAsRoot = runAsRoot;
        return this;
    }

    public RunScriptOptions wrapInInitScript(boolean wrapInInitScript) {
        this.wrapInInitScript = wrapInInitScript;
        return this;
    }

    public RunScriptOptions blockOnComplete(boolean blockOnComplete) {
        this.blockOnComplete = blockOnComplete;
        return this;
    }

    public RunScriptOptions blockOnPort(int port, int seconds) {
        Preconditions.checkArgument((port > 0 && port < 65536 ? 1 : 0) != 0, (Object)"port must be a positive integer < 65535");
        Preconditions.checkArgument((seconds > 0 ? 1 : 0) != 0, (Object)"seconds must be a positive integer");
        this.port = port;
        this.seconds = seconds;
        return this;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getPort() {
        return this.port;
    }

    public int getSeconds() {
        return this.seconds;
    }

    @Nullable
    public String getLoginUser() {
        return this.loginUser;
    }

    @Nullable
    public Boolean shouldAuthenticateSudo() {
        return this.authenticateSudo;
    }

    @Deprecated
    public Credentials getOverridingCredentials() {
        return DefaultCredentialsFromImageOrOverridingCredentials.overrideDefaultCredentialsWithOptionsIfPresent(null, this);
    }

    public boolean hasLoginPasswordOption() {
        return this.loginPassword != null;
    }

    public boolean hasLoginPassword() {
        return this.hasLoginPasswordOption() && this.loginPassword.isPresent();
    }

    @Nullable
    public String getLoginPassword() {
        return this.hasLoginPassword() ? (String)this.loginPassword.get() : null;
    }

    public boolean hasLoginPrivateKeyOption() {
        return this.loginPrivateKey != null;
    }

    public boolean hasLoginPrivateKey() {
        return this.hasLoginPrivateKeyOption() && this.loginPrivateKey.isPresent();
    }

    @Nullable
    public String getLoginPrivateKey() {
        return this.hasLoginPrivateKey() ? (String)this.loginPrivateKey.get() : null;
    }

    public boolean shouldRunAsRoot() {
        return this.runAsRoot;
    }

    public boolean shouldBlockOnComplete() {
        return this.blockOnComplete;
    }

    public boolean shouldWrapInInitScript() {
        return this.wrapInInitScript;
    }

    public String toString() {
        return "[loginUser=" + this.loginUser + ", loginPasswordPresent=" + (this.loginPassword != null) + ", loginPrivateKeyPresent=" + (this.loginPrivateKey != null) + ", shouldAuthenticateSudo=" + this.authenticateSudo + ", port:seconds=" + this.port + ":" + this.seconds + ", runAsRoot=" + this.runAsRoot + ", blockOnComplete=" + this.blockOnComplete + ", wrapInInitScript=" + this.wrapInInitScript + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authenticateSudo == null ? 0 : this.authenticateSudo.hashCode());
        result = 31 * result + (this.blockOnComplete ? 1231 : 1237);
        result = 31 * result + (this.loginPassword == null ? 0 : this.loginPassword.hashCode());
        result = 31 * result + (this.loginPrivateKey == null ? 0 : this.loginPrivateKey.hashCode());
        result = 31 * result + (this.loginUser == null ? 0 : this.loginUser.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.runAsRoot ? 1231 : 1237);
        result = 31 * result + this.seconds;
        result = 31 * result + (this.taskName == null ? 0 : this.taskName.hashCode());
        result = 31 * result + (this.wrapInInitScript ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunScriptOptions other = (RunScriptOptions)obj;
        if (this.authenticateSudo == null ? other.authenticateSudo != null : !this.authenticateSudo.equals(other.authenticateSudo)) {
            return false;
        }
        if (this.blockOnComplete != other.blockOnComplete) {
            return false;
        }
        if (this.loginPassword == null ? other.loginPassword != null : !this.loginPassword.equals(other.loginPassword)) {
            return false;
        }
        if (this.loginPrivateKey == null ? other.loginPrivateKey != null : !this.loginPrivateKey.equals(other.loginPrivateKey)) {
            return false;
        }
        if (this.loginUser == null ? other.loginUser != null : !this.loginUser.equals(other.loginUser)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.runAsRoot != other.runAsRoot) {
            return false;
        }
        if (this.seconds != other.seconds) {
            return false;
        }
        if (this.taskName == null ? other.taskName != null : !this.taskName.equals(other.taskName)) {
            return false;
        }
        return this.wrapInInitScript == other.wrapInInitScript;
    }

    public static class Builder {
        public static RunScriptOptions nameTask(String name) {
            RunScriptOptions options = new RunScriptOptions();
            return options.nameTask(name);
        }

        @Deprecated
        public static RunScriptOptions overrideLoginUserWith(String user) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginUserWith(user);
        }

        public static RunScriptOptions overrideLoginUser(String user) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginUser(user);
        }

        public static RunScriptOptions overrideLoginPassword(String password) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginPassword(password);
        }

        public static RunScriptOptions overrideLoginPrivateKey(String privateKey) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static RunScriptOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        @Deprecated
        public static RunScriptOptions overrideLoginCredentialWith(String credential) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginCredentialWith(credential);
        }

        @Deprecated
        public static RunScriptOptions overrideCredentialsWith(Credentials credentials) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideCredentialsWith(credentials);
        }

        public static RunScriptOptions overrideLoginCredentials(LoginCredentials credentials) {
            RunScriptOptions options = new RunScriptOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static RunScriptOptions runAsRoot(boolean value) {
            RunScriptOptions options = new RunScriptOptions();
            return options.runAsRoot(value);
        }

        public static RunScriptOptions blockOnComplete(boolean value) {
            RunScriptOptions options = new RunScriptOptions();
            return options.blockOnComplete(value);
        }

        public static RunScriptOptions wrapInInitScript(boolean value) {
            RunScriptOptions options = new RunScriptOptions();
            return options.wrapInInitScript(value);
        }

        public static RunScriptOptions blockOnPort(int port, int seconds) {
            RunScriptOptions options = new RunScriptOptions();
            return options.blockOnPort(port, seconds);
        }
    }

    public static class ImmutableRunScriptOptions
    extends RunScriptOptions {
        private final RunScriptOptions delegate;

        public ImmutableRunScriptOptions(RunScriptOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean shouldRunAsRoot() {
            return this.delegate.shouldRunAsRoot();
        }

        @Override
        public RunScriptOptions runAsRoot(boolean runAsRoot) {
            throw new IllegalArgumentException("runAsRoot is immutable");
        }

        @Override
        public boolean shouldBlockOnComplete() {
            return this.delegate.shouldBlockOnComplete();
        }

        @Override
        public RunScriptOptions blockOnComplete(boolean blockOnComplete) {
            throw new IllegalArgumentException("blockOnComplete is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
            throw new IllegalArgumentException("overridingCredentials is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginPassword(String password) {
            throw new IllegalArgumentException("password is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginPrivateKey(String privateKey) {
            throw new IllegalArgumentException("privateKey is immutable");
        }

        @Override
        public RunScriptOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            throw new IllegalArgumentException("authenticateSudo is immutable");
        }

        @Override
        public String getLoginUser() {
            return this.delegate.getLoginUser();
        }

        @Override
        public Boolean shouldAuthenticateSudo() {
            return this.delegate.shouldAuthenticateSudo();
        }

        @Override
        public String getLoginPassword() {
            return this.delegate.getLoginPassword();
        }

        @Override
        public String getLoginPrivateKey() {
            return this.delegate.getLoginPrivateKey();
        }

        @Override
        public boolean shouldWrapInInitScript() {
            return this.delegate.shouldWrapInInitScript();
        }

        @Override
        @Deprecated
        public RunScriptOptions overrideLoginUserWith(String loginUser) {
            throw new IllegalArgumentException("loginUser is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginUser(String loginUser) {
            throw new IllegalArgumentException("loginUser is immutable");
        }

        @Override
        public RunScriptOptions overrideLoginCredentialWith(String loginCredential) {
            throw new IllegalArgumentException("loginCredential is immutable");
        }

        @Override
        public RunScriptOptions wrapInInitScript(boolean wrapInInitScript) {
            throw new IllegalArgumentException("wrapInInitScript is immutable");
        }

        @Override
        @Deprecated
        public RunScriptOptions overrideCredentialsWith(Credentials overridingCredentials) {
            throw new IllegalArgumentException("overridingCredentials is immutable");
        }

        @Override
        public String getTaskName() {
            return this.delegate.getTaskName();
        }

        @Override
        public RunScriptOptions nameTask(String name) {
            throw new IllegalArgumentException("taskName is immutable");
        }

        @Override
        public RunScriptOptions blockOnPort(int port, int seconds) {
            throw new IllegalArgumentException("port, seconds are immutable");
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public int getSeconds() {
            return this.delegate.getSeconds();
        }
    }
}

