/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.logging.Logger;

@Singleton
public class NodePresentAndInIntendedState
implements Predicate<NodeMetadata> {
    private final GetNodeMetadataStrategy client;
    private final NodeState intended;
    private final Set<NodeState> invalids;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public NodePresentAndInIntendedState(NodeState intended, GetNodeMetadataStrategy client) {
        this(intended, (Set<NodeState>)ImmutableSet.of((Object)((Object)NodeState.ERROR)), client);
    }

    public NodePresentAndInIntendedState(NodeState intended, Set<NodeState> invalids, GetNodeMetadataStrategy client) {
        this.intended = intended;
        this.client = client;
        this.invalids = invalids;
    }

    public boolean apply(NodeMetadata node) {
        this.logger.trace("looking for state on node %s", new Object[]{Preconditions.checkNotNull((Object)node, (Object)"node")});
        node = this.refresh(node);
        if (node == null) {
            return false;
        }
        this.logger.trace("%s: looking for node state %s: currently: %s", new Object[]{node.getId(), this.intended, node.getState()});
        if (this.invalids.contains((Object)node.getState())) {
            throw new IllegalStateException("node " + node.getId() + " in location " + node.getLocation() + " is in invalid state " + (Object)((Object)node.getState()));
        }
        return node.getState() == this.intended;
    }

    private NodeMetadata refresh(NodeMetadata node) {
        if (node == null || node.getId() == null) {
            return null;
        }
        return this.client.getNode(node.getId());
    }
}

